/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.player.states.handlers;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.player.ZEScoreBoardManager;
import zombieworldproject.zombieracore.managers.player.states.HealthStateHandlerBase;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class SicknessHandler
extends HealthStateHandlerBase {
    private boolean sick = false;

    public SicknessHandler(PlayerHealth playerHealth) {
        super(playerHealth);
    }

    @Override
    public Boolean isRunning() {
        return this.sick;
    }

    @Override
    public void setState(HealthStates state, Boolean enabled) {
        this.playerHealth.getHealth().put(state, enabled);
        if (!this.isRunning().booleanValue()) {
            this.runStates();
        }
        this.onStateChange();
    }

    @Override
    public void onStateChange() {
        ZEScoreBoardManager.setScoreBoardPlayer(this.playerHealth.getPlayer());
    }

    public void runStates() {
        if (this.sick) {
            return;
        }
        this.sick = true;
        new BukkitRunnable(){

            public void run() {
                boolean enabled;
                final Player player = SicknessHandler.this.playerHealth.getPlayer();
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                boolean bl = enabled = SicknessHandler.this.playerHealth.getHealth().get((Object)HealthStates.SICK) != false || SicknessHandler.this.playerHealth.getHealth().get((Object)HealthStates.STOMACH_SICKNESS) != false;
                if (!enabled) {
                    SicknessHandler.this.sick = false;
                    this.cancel();
                    return;
                }
                if (Boolean.TRUE.equals(SicknessHandler.this.playerHealth.getHealth().get((Object)HealthStates.SICK))) {
                    // empty if block
                }
                if (Boolean.TRUE.equals(SicknessHandler.this.playerHealth.getHealth().get((Object)HealthStates.STOMACH_SICKNESS))) {
                    if (player.getFoodLevel() > 0 && MiscUtils.generateChance(33)) {
                        ZombiEraCore.getSoundManager().playSound(player.getLocation(), "vomit");
                        player.setFoodLevel(0);
                        SicknessHandler.this.playerHealth.addWater(-3);
                        final Location playerEyeLocation = player.getEyeLocation();
                        new BukkitRunnable(){
                            int count = 0;

                            public void run() {
                                Location particleLocation = playerEyeLocation.clone().add(playerEyeLocation.getDirection().multiply(0.5)).add(0.0, -0.2, 0.0);
                                player.spawnParticle(Particle.REDSTONE, particleLocation, 30, 0.0, 0.0, 0.0, 1.0, (Object)new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)0), 1.0f));
                                if (++this.count > 4) {
                                    this.cancel();
                                }
                            }
                        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 5L);
                    } else if (MiscUtils.generateChange(10.0f)) {
                        SicknessHandler.this.playerHealth.setSickness(HealthStates.STOMACH_SICKNESS, false);
                    }
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 1200L);
    }
}

