/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.data.LootAblePropData;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class PropBase
implements ItemBase {
    private final Boolean marker;
    private final Boolean isSaved;
    public Integer nbtId;
    public String displayName;
    public String dirName;
    public Boolean setArmZero;
    private ItemStack thisItem;
    private PropHandler propHandler;
    private Boolean lootAble = false;
    private LootAblePropData lootablePropData;

    public PropBase(Integer nbtId, String dirName, String displayName, Boolean setArmZero, Boolean marker, Boolean isSaved) {
        this.nbtId = nbtId;
        this.displayName = displayName;
        this.dirName = dirName;
        this.setArmZero = setArmZero;
        this.marker = marker;
        this.isSaved = isSaved;
        ZombiEraCore.getPropManager().propItems.put(nbtId, this);
        ZombiEraCore.getPropManager().propItemsDirNames.put(dirName, nbtId);
    }

    public Boolean isSaved() {
        return this.isSaved;
    }

    public Boolean isLootAble() {
        return this.lootAble;
    }

    public LootAblePropData getLootablePropData() {
        if (this.isLootAble().booleanValue()) {
            return this.lootablePropData;
        }
        return null;
    }

    public void setLootAble(PropBase full, PropBase empty, String rarityGroup, Boolean onOpenAnimation) {
        this.lootAble = true;
        this.lootablePropData = new LootAblePropData(full, empty, rarityGroup, onOpenAnimation);
    }

    public Boolean isMarker() {
        return this.marker;
    }

    public PropHandler getPropHandler() {
        return this.propHandler;
    }

    public void setPropHandler(PropHandler propHandler) {
        this.propHandler = propHandler;
    }

    public void addPropToWorldNow(Location location) {
        ZombiEraCore.getPropManager().addPropToChunkNow(this, location);
    }

    @Override
    public String getDirName() {
        return this.dirName;
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public Integer getNBTTag() {
        return this.nbtId;
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        return this.thisItem;
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.MOJANG_BANNER_PATTERN);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.getRarity()), this.displayName));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Special Prop");
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(this.nbtId);
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    public String getRarity() {
        return null;
    }

    @Override
    public Integer getDropWeight() {
        return null;
    }
}

