/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.json.simple.JSONObject;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.PropBase;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.data.ChunkPropsData;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.DefaultLootAbleProp;
import zombieworldproject.zombieracore.managers.props.handlers.PlayerDeathLootDrop;
import zombieworldproject.zombieracore.managers.props.handlers.player.C4Player;
import zombieworldproject.zombieracore.managers.props.handlers.player.LandClaimerProp;
import zombieworldproject.zombieracore.managers.props.handlers.player.LandminePlayer;
import zombieworldproject.zombieracore.managers.props.handlers.player.StorageProp;
import zombieworldproject.zombieracore.managers.props.handlers.server.AirBomb;
import zombieworldproject.zombieracore.managers.props.handlers.server.BearTrapOpened;
import zombieworldproject.zombieracore.managers.props.handlers.server.ClosedCorpseBag;
import zombieworldproject.zombieracore.managers.props.handlers.server.GasPump;
import zombieworldproject.zombieracore.managers.props.handlers.server.GoreHandler;
import zombieworldproject.zombieracore.managers.props.handlers.server.Landmine;
import zombieworldproject.zombieracore.managers.props.handlers.server.LuckyChest;
import zombieworldproject.zombieracore.managers.props.handlers.server.LuckyChestQuestionMark;
import zombieworldproject.zombieracore.managers.props.handlers.server.SewerSporeEgg;
import zombieworldproject.zombieracore.managers.props.handlers.server.SupplyDrop;
import zombieworldproject.zombieracore.managers.props.handlers.server.Turret;
import zombieworldproject.zombieracore.managers.props.handlers.server.WaterPump;
import zombieworldproject.zombieracore.managers.props.handlers.server.ZombieNest;
import zombieworldproject.zombieracore.managers.props.items.C4Item;
import zombieworldproject.zombieracore.managers.props.items.LandClaimer;
import zombieworldproject.zombieracore.managers.props.items.LandmineItem;
import zombieworldproject.zombieracore.managers.props.items.PlayerStorage;
import zombieworldproject.zombieracore.misc.utils.PlayerUtils;
import zombieworldproject.zombieracore.remote.database.handlers.DBPropHandler;
import zombieworldproject.zombieracore.remote.database.views.PropDataView;

public class ZEPropManager {
    public final Map<Integer, PropBase> propItems = new HashMap<Integer, PropBase>();
    public final Map<String, PropHandler> propHandlers = new HashMap<String, PropHandler>();
    public final Map<String, Integer> propItemsDirNames = new HashMap<String, Integer>();
    public final Map<String, ChunkPropsData> chunkPropsDataMap = new HashMap<String, ChunkPropsData>();
    public final Map<Integer, PropData> propDataMap = new HashMap<Integer, PropData>();
    public final List<PropData> propDataNotSaved = new ArrayList<PropData>();
    public final Map<Integer, PropData> propDataMapNotSaved = new HashMap<Integer, PropData>();
    public final Map<PropData, Integer> configPropData = new HashMap<PropData, Integer>();
    public final List<PropDataView> propsDatabase = new ArrayList<PropDataView>();
    public final Map<String, String> propNamesHandlers = new HashMap<String, String>();
    private int propCounter = 0;
    private File configFile;

    public ZEPropManager() {
        this.loadAllPropsFromDatabase();
        this.loadPropHandlers();
        this.propHandlers.forEach((key, value) -> ZombiEraCore.debugInfo("Handler registered: " + key));
    }

    public void initialize() {
        ZombiEraCore.getItemManager().updateMappedItemBases();
    }

    public PropBase getPropByDirName(String dirName) {
        return this.propItems.get(this.propItemsDirNames.get(dirName));
    }

    public ChunkPropsData getChunkPropsData(int x, int z, World world) {
        return this.chunkPropsDataMap.get(String.format("%s_%s_%s", x, z, world.getName()));
    }

    public void onEntityClickEvent(PlayerInteractAtEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof ArmorStand)) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)entity;
        PropData pd = this.propDataMapNotSaved.get(armorStand.getEntityId());
        if (pd == null) {
            pd = this.propDataMap.get(armorStand.getEntityId());
        }
        if (pd == null) {
            return;
        }
        PropHandler handler = pd.prop.getPropHandler();
        if (handler != null) {
            ZombiEraCore.debugInfo("Right click");
            handler.handleClick(true, pd, event.getPlayer());
        }
    }

    public void onEntityClickEvent(ArmorStand armorStand, Player player) {
        PropData pd = this.propDataMapNotSaved.get(armorStand.getEntityId());
        if (pd == null) {
            pd = this.propDataMap.get(armorStand.getEntityId());
        }
        if (pd == null) {
            return;
        }
        PropHandler handler = pd.prop.getPropHandler();
        if (handler != null) {
            ZombiEraCore.debugInfo("Left click");
            handler.handleClick(false, pd, player);
        }
    }

    public void onEntityClickEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Collection armorStands = player.getLocation().getNearbyEntitiesByType(ArmorStand.class, 2.0, 2.0, 2.0);
        if (armorStands.isEmpty()) {
            return;
        }
        boolean[] markers = new boolean[armorStands.size()];
        int i = 0;
        for (ArmorStand as : armorStands) {
            markers[i] = as.isMarker();
            if (!as.isSmall()) {
                as.setMarker(false);
                as.setInvulnerable(false);
            }
            ++i;
        }
        RayTraceResult res = player.getWorld().rayTraceEntities(player.getEyeLocation().add(player.getLocation().getDirection()), player.getEyeLocation().getDirection(), 3.0, entity -> !entity.getUniqueId().equals(player.getUniqueId()));
        if (res != null && res.getHitEntity() != null) {
            PropHandler handler;
            Entity entity2 = res.getHitEntity();
            PropData pd = this.propDataMapNotSaved.get(entity2.getEntityId());
            if (pd == null) {
                pd = this.propDataMap.get(entity2.getEntityId());
            }
            if (pd != null && (handler = pd.prop.getPropHandler()) != null) {
                handler.handleClick(event.getAction().isRightClick(), pd, event.getPlayer());
            }
        }
        i = 0;
        for (ArmorStand as : armorStands) {
            if (!as.isSmall()) {
                as.setMarker(markers[i]);
                as.setInvulnerable(true);
            }
            ++i;
        }
    }

    public void deleteAllUnsavedProps() {
        this.propDataNotSaved.forEach(PropData::deSpawn);
    }

    public void loadAllPropsFromDatabase() {
        ZombiEraCore.debugInfo("Props are being loaded from the database...");
        this.propsDatabase.clear();
        this.propsDatabase.addAll(DBPropHandler.loadAllProps());
        ZombiEraCore.debugInfo("Props loaded from the database.");
    }

    public void loadDataForWorld(World world) {
        String worldName = world.getName();
        for (PropDataView view : this.propsDatabase) {
            if (!view.getWorld().equals(worldName)) continue;
            int propId = view.getId();
            String propName = view.getProp();
            Vector direction = new Vector(view.getxD(), view.getyD(), view.getzD());
            Location location = new Location(world, view.getX(), view.getY(), view.getZ(), view.getYaw().floatValue(), view.getPitch().floatValue());
            location.setDirection(direction);
            PropBase prop = this.propItems.get(this.propItemsDirNames.get(propName));
            PropData pd = this.addPropToChunk(prop, location);
            pd.setPropMetaData("database", view.getMetadata());
            this.configPropData.put(pd, propId);
        }
        ZombiEraCore.debugInfo("Loaded prop chunks to memory.");
    }

    public PropData addPropToChunk(PropBase prop, Location location) {
        int chunkX = this.floor(location.getX()) >> 4;
        int chunkZ = this.floor(location.getZ()) >> 4;
        String chunkKey = String.format("%s_%s_%s", chunkX, chunkZ, location.getWorld().getName());
        ChunkPropsData chunkData = this.chunkPropsDataMap.computeIfAbsent(chunkKey, k -> new ChunkPropsData(chunkX, chunkZ, location.getWorld()));
        return chunkData.addProp(prop, location);
    }

    public PropData addPropToChunkNow(PropBase prop, Location location) {
        int chunkX = this.floor(location.getX()) >> 4;
        int chunkZ = this.floor(location.getZ()) >> 4;
        String chunkKey = String.format("%s_%s_%s", chunkX, chunkZ, location.getWorld().getName());
        ChunkPropsData chunkData = this.chunkPropsDataMap.computeIfAbsent(chunkKey, k -> new ChunkPropsData(chunkX, chunkZ, location.getWorld()));
        PropData pd = chunkData.addPropNow(prop, location);
        this.addPropToDatabase(pd);
        return pd;
    }

    public PropData addPropToWorldNotSaved(PropBase prop, Location location) {
        PropData pd = new PropData(prop, location, null);
        pd.spawn(location.getWorld());
        this.propDataNotSaved.add(pd);
        return pd;
    }

    public PropData addPropToWorldNotSaved(PropBase prop, Location location, boolean spawnOnlyOnce) {
        PropData pd = new PropData(prop, location, null, spawnOnlyOnce);
        pd.spawn(location.getWorld());
        this.propDataNotSaved.add(pd);
        return pd;
    }

    public int getNewPropId() {
        return ++this.propCounter;
    }

    public Integer getPropId(PropData pd) {
        return this.configPropData.get(pd);
    }

    public PropData getPropDataById(int id) {
        for (Map.Entry<PropData, Integer> entry : this.configPropData.entrySet()) {
            if (id != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    public void removeProp(PropData pd) {
        Integer propId = this.getPropId(pd);
        if (propId == null) {
            return;
        }
        PropDataView view = new PropDataView();
        view.setId(propId);
        if (DBPropHandler.deleteProp(view)) {
            this.configPropData.remove(pd);
            ZombiEraCore.debugInfo("Prop deleted from the database.");
        }
    }

    public void savePropMetaData(PropData pd) {
        Integer propId = this.getPropId(pd);
        if (propId == null) {
            return;
        }
        JSONObject object = (JSONObject)pd.getPropMetaData("database");
        if (object == null) {
            ZombiEraCore.debugInfo("Metadata is null");
            return;
        }
        PropDataView view = new PropDataView();
        view.setId(propId);
        view.setMetadata(object);
        DBPropHandler.updatePropMetaData(view);
    }

    public void addPropToDatabase(PropData pd) {
        int propId;
        PropDataView view = new PropDataView();
        Location loc = pd.getLocation();
        view.setProp(pd.getPropName());
        view.setX(loc.getX());
        view.setY(loc.getY());
        view.setZ(loc.getZ());
        view.setPitch(loc.getPitch());
        view.setYaw(loc.getYaw());
        view.setxD(loc.getDirection().getX());
        view.setyD(loc.getDirection().getY());
        view.setzD(loc.getDirection().getZ());
        view.setWorld(loc.getWorld().getName());
        JSONObject metadata = (JSONObject)pd.getPropMetaData("database");
        if (metadata != null) {
            view.setMetadata(metadata);
        }
        if ((propId = DBPropHandler.saveProp(view)) == -1) {
            ZombiEraCore.debugInfo("Prop could not be saved to the database.");
            return;
        }
        this.configPropData.put(pd, propId);
        ZombiEraCore.debugInfo("New prop db id: " + propId);
    }

    public int floor(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor - (int)(Double.doubleToRawLongBits(num) >>> 63);
    }

    public void loadPropHandlers() {
        this.propHandlers.put("default_loot", new DefaultLootAbleProp());
        this.propHandlers.put("gas_pump", new GasPump());
        this.propHandlers.put("water_pump", new WaterPump());
        this.propHandlers.put("closed_corpse_bag", new ClosedCorpseBag());
        this.propHandlers.put("sewer_egg", new SewerSporeEgg());
        this.propHandlers.put("landmine", new Landmine());
        this.propHandlers.put("bear_trap_opened", new BearTrapOpened());
        this.propHandlers.put("supply_drop", new SupplyDrop());
        this.propHandlers.put("turret", new Turret());
        this.propHandlers.put("player_death_loop_drop", new PlayerDeathLootDrop());
        this.propHandlers.put("luckychest", new LuckyChest());
        this.propHandlers.put("luckychest_question", new LuckyChestQuestionMark());
        this.propHandlers.put("player_landmine", new LandminePlayer());
        this.propHandlers.put("player_c4", new C4Player());
        this.propHandlers.put("air_bomb", new AirBomb());
        this.propHandlers.put("land_claimer", new LandClaimerProp());
        this.propHandlers.put("gore", new GoreHandler());
        this.propHandlers.put("storage", new StorageProp());
        this.propHandlers.put("zombienest", new ZombieNest());
    }

    public void setPropHandler(PropBase prop, String handlerName) {
        prop.setPropHandler(this.propHandlers.get(handlerName));
        this.propNamesHandlers.put(prop.getDirName(), handlerName);
    }

    public void loadDefaultProp(String dirName, int nbtId, String display, boolean marker, boolean isSaved, boolean setArmZero, String handler) {
        PropBase prop = new PropBase(nbtId, dirName, display, setArmZero, marker, isSaved);
        if (handler != null) {
            this.setPropHandler(prop, handler);
        }
    }

    public void loadLootProp(String closedProp, String openedProp, boolean openAnimation, String rarityGroup) {
        PropBase main = this.getPropByDirName(closedProp);
        PropBase open = this.getPropByDirName(openedProp);
        main.setLootAble(main, open, rarityGroup, openAnimation);
    }

    public PropData placeProp(Player player, int maxDistance, String propName) {
        Vector targetLoc = PlayerUtils.getPlayerTargetLocation(player, maxDistance);
        if (targetLoc == null) {
            return null;
        }
        Location location = new Location(player.getWorld(), targetLoc.getX(), targetLoc.getY(), targetLoc.getZ());
        location.setDirection(player.getLocation().getDirection());
        return ZombiEraCore.getPropManager().addPropToChunkNow(ZombiEraCore.getPropManager().getPropByDirName(propName), location);
    }

    @Nullable
    public Location placeProp(Player player, int maxDistance) {
        Vector targetLoc = PlayerUtils.getPlayerTargetLocation(player, maxDistance);
        if (targetLoc == null) {
            return null;
        }
        return new Location(player.getWorld(), targetLoc.getX(), targetLoc.getY(), targetLoc.getZ());
    }

    public void addPropItems() {
        new LandmineItem();
        new C4Item();
        new LandClaimer();
        new PlayerStorage();
    }
}

