/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.data;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.PropBase;
import zombieworldproject.zombieracore.managers.props.data.PropData;

public class ChunkPropsData {
    private final List<PropData> propsList = new ArrayList<PropData>();
    private final int x;
    private final int z;
    private final World world;
    private boolean active = false;

    public ChunkPropsData(int x, int z, World world) {
        this.x = x;
        this.z = z;
        this.world = world;
    }

    public boolean isActive() {
        return this.active;
    }

    public World getWorld() {
        return this.world;
    }

    public PropData findPropByEntityId(int entityId) {
        for (PropData pd : this.propsList) {
            if (pd == null || pd.getId() == null || !pd.getId().equals(entityId)) continue;
            return pd;
        }
        return null;
    }

    public boolean removePropByEntityId(int entityId) {
        PropData pd = this.findPropByEntityId(entityId);
        if (pd == null) {
            return false;
        }
        pd.deSpawn();
        ZombiEraCore.getPropManager().removeProp(pd);
        this.propsList.remove(pd);
        return true;
    }

    public void loadLatest(World world) {
        if (this.propsList.isEmpty()) {
            return;
        }
        PropData latest = this.propsList.get(this.propsList.size() - 1);
        if (latest != null) {
            latest.spawn(world);
        }
        this.active = true;
    }

    public void loadAll() {
        if (this.active) {
            this.unloadAll();
        }
        for (PropData prop : this.propsList) {
            if (prop == null) continue;
            prop.spawn();
        }
        this.active = true;
    }

    public void unloadAll() {
        for (PropData prop : this.propsList) {
            if (prop == null) continue;
            prop.deSpawn();
        }
        this.active = false;
    }

    public PropData addProp(PropBase prop, Location location) {
        if (prop == null || location == null) {
            return null;
        }
        PropData pd = new PropData(prop, location, this);
        this.propsList.add(pd);
        return pd;
    }

    public PropData addPropNow(PropBase prop, Location location) {
        if (prop == null || location == null) {
            return null;
        }
        PropData pd = new PropData(prop, location, this);
        this.propsList.add(pd);
        this.loadLatest(location.getWorld());
        return pd;
    }

    public List<PropData> getPropsList() {
        return this.propsList;
    }

    public int getChunkX() {
        return this.x;
    }

    public int getChunkZ() {
        return this.z;
    }
}

