/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.data;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.ZERarityDropManager;
import zombieworldproject.zombieracore.managers.props.PropBase;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.DefaultLootAbleProp;

public class LootAblePropData {
    public boolean onOpenAnimation;
    private boolean init = false;
    private boolean runningReset = false;
    private boolean isOpened = false;
    private boolean lootOnlyOnce = false;
    private boolean looted = false;
    public PropBase fullProp;
    public PropBase emptyProp;
    public String rarityGroup;
    private Inventory inventory;
    private ZERarityDropManager.RarityGroup lootGroup = null;
    private PropData propData;
    private LocalDateTime nextGeneratedDate;

    public LootAblePropData(PropBase fullProp, PropBase emptyProp, String rarityGroup, boolean onOpenAnimation) {
        this(fullProp, emptyProp, rarityGroup, null, onOpenAnimation);
    }

    public LootAblePropData(PropBase fullProp, PropBase emptyProp, String rarityGroup, PropData propData, boolean onOpenAnimation) {
        this.fullProp = fullProp;
        this.emptyProp = emptyProp;
        this.rarityGroup = rarityGroup;
        this.propData = propData;
        this.onOpenAnimation = onOpenAnimation;
        if (rarityGroup != null) {
            this.lootGroup = ZombiEraCore.getRarityDropManager().groupRarities.get(rarityGroup);
            if (this.lootGroup == null) {
                ZombiEraCore.debugInfo(String.format("WARNING: Missing rarity group '%s' for prop '%s'.", rarityGroup, fullProp != null ? fullProp.getName() : "Unknown"));
            }
        }
    }

    public void initInventory(Integer entityId) {
        this.inventory = Bukkit.createInventory(null, (int)54, (String)("p" + entityId));
        this.nextGeneratedDate = LocalDateTime.now();
        this.generateLoot(true);
        this.runningReset = false;
        this.init = true;
    }

    public void openInventory(Player player) {
        if (this.isOpened) {
            return;
        }
        this.isOpened = true;
        if (this.onOpenAnimation) {
            this.propData.setItem(this.emptyProp);
        }
        if (this.lootGroup == null) {
            if (this.lootOnlyOnce && !this.looted) {
                this.looted = true;
                this.generateLoot(true);
            } else if (!this.lootOnlyOnce) {
                this.generateLoot(false);
            }
        }
        ((DefaultLootAbleProp)this.propData.prop.getPropHandler()).onInventoryOpen(this.propData);
        player.openInventory(this.inventory);
    }

    public void closeInventoryEvent(InventoryCloseEvent event) {
        ((DefaultLootAbleProp)this.propData.prop.getPropHandler()).onInventoryClose(event, this.propData);
    }

    public void clickInventory(InventoryClickEvent event) {
        ((DefaultLootAbleProp)this.propData.prop.getPropHandler()).onInventoryClick(event, this.propData);
    }

    public void generateLoot(boolean force) {
        if (this.lootGroup == null) {
            return;
        }
        if (this.lootOnlyOnce && this.looted) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        if (!force && this.nextGeneratedDate != null && !now.isAfter(this.nextGeneratedDate)) {
            return;
        }
        if (force) {
            this.inventory.clear();
        }
        if (this.inventory.isEmpty()) {
            List<ItemStack> items = this.lootGroup.generateItemStacks();
            items.forEach(item -> {
                if (item != null) {
                    this.inventory.addItem(new ItemStack[]{item});
                }
            });
            this.runningReset = false;
            this.nextGeneratedDate = now.plusSeconds(this.lootGroup.crateRespawnLootSeconds.intValue());
        }
    }

    public void resetTimer() {
        this.isOpened = false;
        if (this.lootGroup == null || this.runningReset || this.inventory == null) {
            return;
        }
        if (this.inventory.isEmpty()) {
            this.nextGeneratedDate = LocalDateTime.now().plusSeconds(this.lootGroup.crateRespawnLootSeconds.intValue());
            this.runningReset = true;
            this.propData.setItem(this.emptyProp);
            new BukkitRunnable(){

                public void run() {
                    if (LootAblePropData.this.inventory.isEmpty() && LootAblePropData.this.runningReset && LootAblePropData.this.propData.isSpawned().booleanValue()) {
                        LootAblePropData.this.propData.setItem(LootAblePropData.this.fullProp);
                        LootAblePropData.this.generateLoot(true);
                    }
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, this.getSecondsUntilRespawn() * 20L);
        } else if (this.onOpenAnimation) {
            this.propData.setItem(this.fullProp);
        }
    }

    public long getSecondsUntilRespawn() {
        if (this.nextGeneratedDate == null) {
            return 0L;
        }
        long duration = Duration.between(LocalDateTime.now(), this.nextGeneratedDate).getSeconds();
        return Math.max(duration, 0L);
    }

    public List<ItemStack> getItems() {
        return Arrays.stream(this.inventory.getContents()).toList();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(List<ItemStack> items) {
        if (this.inventory == null) {
            return;
        }
        this.inventory.clear();
        items.stream().filter(item -> item != null).forEach(xva$0 -> this.inventory.addItem(new ItemStack[]{xva$0}));
    }

    public void setPropData(PropData propData) {
        this.propData = propData;
    }

    public ZERarityDropManager.RarityGroup getLootGroup() {
        return this.lootGroup;
    }

    public void setLootOnlyOnce(boolean lootOnlyOnce) {
        this.lootOnlyOnce = lootOnlyOnce;
    }
}

