/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.PropBase;
import zombieworldproject.zombieracore.managers.props.PropCollisionHandler;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.PropTickHandler;
import zombieworldproject.zombieracore.managers.props.data.ChunkPropsData;
import zombieworldproject.zombieracore.managers.props.data.LootAblePropData;

public class PropData {
    private final ChunkPropsData chunkPropsData;
    public PropBase prop;
    public Location location;
    public Integer ticksNow = 0;
    public HashMap<String, Object> propMetaData = new HashMap();
    World world;
    ArmorStand armorStand;
    private String lastItemPropDirName;
    private Boolean enableTicking = false;
    private Boolean collidable = false;
    private Integer collidableTicksDelay = 60;
    private LootAblePropData lootAblePropData;
    private Boolean spawnOnlyOnce = false;
    private Integer spawned = 0;
    private Boolean active = true;
    private boolean removed = false;

    public PropData(PropBase prop, Location location, ChunkPropsData chunkPropsData) {
        this.prop = prop;
        this.location = location;
        this.world = location.getWorld();
        this.chunkPropsData = chunkPropsData;
        if (prop.isLootAble().booleanValue()) {
            LootAblePropData data = prop.getLootablePropData();
            this.lootAblePropData = new LootAblePropData(data.fullProp, data.emptyProp, data.rarityGroup, this, data.onOpenAnimation);
        }
    }

    public PropData(PropBase prop, Location location, ChunkPropsData chunkPropsData, Boolean spawnOnlyOnce) {
        this.prop = prop;
        this.location = location;
        this.world = location.getWorld();
        this.chunkPropsData = chunkPropsData;
        this.spawnOnlyOnce = spawnOnlyOnce;
        if (prop.isLootAble().booleanValue()) {
            LootAblePropData data = prop.getLootablePropData();
            this.lootAblePropData = new LootAblePropData(data.fullProp, data.emptyProp, data.rarityGroup, this, data.onOpenAnimation);
        }
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setPropMetaData(String key, Object data) {
        this.propMetaData.put(key, data);
    }

    public Object getPropMetaData(String key) {
        return this.propMetaData.get(key);
    }

    public Object getPropMetaData(String key, Object defaultValue) {
        return this.propMetaData.getOrDefault(key, defaultValue);
    }

    public HashMap<String, Object> getAllMetaData() {
        return this.propMetaData;
    }

    public Location getLocation() {
        return this.location.clone();
    }

    public void setLocation(Location location) {
        this.location = location;
        if (this.isSpawned().booleanValue()) {
            this.armorStand.teleport(location);
        }
    }

    public void setLocationWithChunk(final Location location) {
        this.location = location;
        this.armorStand.teleport(location);
        final Chunk chunk = location.getChunk();
        final Integer[] count = new Integer[]{0};
        if (!chunk.isLoaded()) {
            chunk.load(true);
            new BukkitRunnable(){

                public void run() {
                    count[0] = count[0] + 1;
                    if (!location.getChunk().equals((Object)chunk) || !PropData.this.isSpawned().booleanValue() || count[0] > 300) {
                        chunk.unload();
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 20L);
        }
    }

    public Boolean isLootAble() {
        return this.prop.isLootAble();
    }

    public LootAblePropData getLootAblePropData() {
        return this.lootAblePropData;
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public Boolean isCollidable() {
        return this.collidable;
    }

    public String getLastPropItemDirname() {
        return this.lastItemPropDirName;
    }

    public void setLastPropItemDirname(String lastItemPropDirName) {
        this.lastItemPropDirName = lastItemPropDirName;
    }

    public ChunkPropsData getChunkPropsData() {
        return this.chunkPropsData;
    }

    public String getPropName() {
        return this.prop.dirName;
    }

    public Integer getId() {
        if (this.armorStand != null && this.armorStand.isValid()) {
            return this.armorStand.getEntityId();
        }
        return -1;
    }

    public void resetTimer() {
        this.ticksNow = 0;
    }

    public Boolean isTicking() {
        return this.enableTicking != false && this.isSpawned() != false;
    }

    public Boolean isSpawned() {
        return this.getId() != -1;
    }

    public void showAS() {
        if (this.isSpawned().booleanValue()) {
            this.armorStand.setVisible(true);
        }
    }

    public void hideAS() {
        if (this.isSpawned().booleanValue()) {
            this.armorStand.setVisible(false);
        }
    }

    public void spawn(World world) {
        if (!this.active.booleanValue()) {
            return;
        }
        if (this.isSpawned().booleanValue()) {
            return;
        }
        if (this.spawnOnlyOnce.booleanValue() && this.spawned > 0) {
            return;
        }
        this.spawned = this.spawned + 1;
        this.location.setWorld(world);
        this.armorStand = (ArmorStand)world.spawn(this.location, ArmorStand.class, as -> {
            as.setInvisible(true);
            as.setGravity(false);
            as.setAI(false);
            as.setMarker(this.prop.isMarker().booleanValue());
        });
        if (!this.prop.isSaved().booleanValue()) {
            this.armorStand.setPersistent(true);
        }
        int id = this.armorStand.getEntityId();
        if (this.isLootAble().booleanValue()) {
            ArrayList<ItemStack> items = new ArrayList();
            if (this.lootAblePropData.getInventory() != null) {
                items = new ArrayList<ItemStack>(this.lootAblePropData.getItems());
            }
            this.lootAblePropData.initInventory(id);
            if (items.size() > 0) {
                this.lootAblePropData.setInventory(items);
            }
        }
        if (this.chunkPropsData == null) {
            ZombiEraCore.getPropManager().propDataMapNotSaved.put(id, this);
        } else {
            ZombiEraCore.getPropManager().propDataMap.put(id, this);
        }
        this.hideAS();
        this.setItem();
        if (this.prop.setArmZero.booleanValue()) {
            this.armorStand.setLeftArmPose(new EulerAngle(0.0, 0.0, 0.0));
        }
        if (this.prop.getPropHandler() == null) {
            return;
        }
        PropHandler propHandler = this.prop.getPropHandler();
        if (propHandler instanceof PropTickHandler) {
            PropTickHandler tickHandler = (PropTickHandler)((Object)propHandler);
            this.enableTicking = true;
            tickHandler.runBehaviour(this);
        }
        if ((propHandler = this.prop.getPropHandler()) instanceof PropCollisionHandler) {
            final PropCollisionHandler colliderHandler = (PropCollisionHandler)((Object)propHandler);
            final PropData thisInstance = this;
            this.collidable = true;
            new BukkitRunnable(){

                public void run() {
                    if (PropData.this.isSpawned().booleanValue()) {
                        List entities = (List)PropData.this.location.getNearbyLivingEntities(colliderHandler.getCollisionSphereSize().doubleValue());
                        for (LivingEntity le : entities) {
                            if (le instanceof ArmorStand) continue;
                            colliderHandler.onCollision(thisInstance, le);
                        }
                    } else {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)ZombiEraCore.instance, (long)this.collidableTicksDelay.intValue(), 5L);
            this.collidableTicksDelay = 0;
        }
    }

    public void setItem() {
        if (this.isSpawned().booleanValue()) {
            this.armorStand.setItem(EquipmentSlot.OFF_HAND, this.prop.getItem());
            this.lastItemPropDirName = this.prop.dirName;
        }
    }

    public void setItem(PropBase prop) {
        if (this.isSpawned().booleanValue()) {
            this.armorStand.setItem(EquipmentSlot.OFF_HAND, prop.getItem());
            this.lastItemPropDirName = prop.dirName;
        }
    }

    public void setItem(ItemStack item) {
        if (this.isSpawned().booleanValue()) {
            this.armorStand.setItem(EquipmentSlot.OFF_HAND, item);
            this.lastItemPropDirName = item.getType().toString();
        }
    }

    public void spawn() {
        if (!this.active.booleanValue()) {
            return;
        }
        if (this.world != null) {
            this.spawn(this.world);
        }
    }

    public void deSpawn() {
        if (this.isSpawned().booleanValue()) {
            PropHandler propHandler;
            if (this.prop.getPropHandler() != null && (propHandler = this.prop.getPropHandler()) instanceof PropTickHandler) {
                PropTickHandler tickHandler = (PropTickHandler)((Object)propHandler);
                this.enableTicking = false;
                tickHandler.stopBehaviour(this);
                if (this.chunkPropsData == null) {
                    ZombiEraCore.getPropManager().propDataMapNotSaved.remove(this.getId());
                } else {
                    ZombiEraCore.getPropManager().propDataMap.remove(this.getId());
                }
            }
            this.armorStand.remove();
        }
    }

    public void remove() {
        if (!this.prop.isSaved().booleanValue()) {
            ZombiEraCore.getPropManager().propDataNotSaved.remove(this);
            this.active = false;
        } else {
            this.getChunkPropsData().removePropByEntityId(this.getId());
        }
        this.removed = true;
        this.deSpawn();
    }
}

