/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.PropTickHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.DefaultLootAbleProp;

public class PlayerDeathLootDrop
extends DefaultLootAbleProp
implements PropTickHandler {
    @Override
    public void handleClick(boolean isRightClick, PropData propData, Player player) {
        if (!isRightClick) {
            int hit = propData.getPropMetaData("hit") instanceof Integer ? (Integer)propData.getPropMetaData("hit") : 0;
            int afterHit = hit + 1;
            if (afterHit >= 5) {
                propData.remove();
            } else {
                propData.setPropMetaData("hit", afterHit);
            }
            return;
        }
        if (propData.isLootAble().booleanValue() && propData.getLootAblePropData() != null) {
            propData.getLootAblePropData().openInventory(player);
        }
    }

    @Override
    public void onInventoryOpen(PropData pd) {
    }

    @Override
    public void onInventoryClose(InventoryCloseEvent event, PropData pd) {
        if (pd == null || pd.isRemoved()) {
            return;
        }
        if (pd.getLootAblePropData() != null && pd.getLootAblePropData().getInventory().isEmpty()) {
            pd.remove();
        }
    }

    @Override
    public void runBehaviour(final PropData pd) {
        if (pd == null || pd.isRemoved()) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                UUID uuid;
                if (pd.isRemoved() || pd.getArmorStand() == null) {
                    this.cancel();
                    return;
                }
                Object uuidObj = pd.getPropMetaData("player_uuid");
                if (!(uuidObj instanceof String)) {
                    return;
                }
                String uuidStr = (String)uuidObj;
                try {
                    uuid = UUID.fromString(uuidStr);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (offlinePlayer == null) {
                    return;
                }
                ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
                SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
                if (meta != null) {
                    meta.setOwningPlayer(offlinePlayer);
                    playerHead.setItemMeta((ItemMeta)meta);
                }
                if (pd.getArmorStand() != null && pd.getArmorStand().getEquipment() != null) {
                    pd.getArmorStand().getEquipment().setHelmet(playerHead);
                }
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 1L);
        new BukkitRunnable(){
            final double step = 0.1;
            int ticks = 0;
            final int maxTicks = 200;

            public void run() {
                if (pd.isRemoved() || pd.getLocation() == null) {
                    this.cancel();
                    return;
                }
                Location below = pd.getLocation().clone().subtract(0.0, 0.1, 0.0);
                if (below.getBlock().getType().isSolid() || this.ticks >= 200) {
                    this.cancel();
                    return;
                }
                pd.setLocation(below);
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 1L);
        new BukkitRunnable(){

            public void run() {
                if (!pd.isRemoved()) {
                    pd.remove();
                }
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 36000L);
    }

    @Override
    public void stopBehaviour(PropData pd) {
    }
}

