/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.player;

import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.door.DoorTypes;
import zombieworldproject.zombieracore.managers.door.ZDoor;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.PropTickHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;

public class C4Player
implements PropHandler,
PropTickHandler {
    private static final int INITIAL_COUNTDOWN = 100;
    private static final int INITIAL_BEEP_FREQUENCY = 12;
    private static final int TICK_INTERVAL = 3;

    @Override
    public void runBehaviour(final PropData pd) {
        if (pd == null || pd.isRemoved()) {
            return;
        }
        new BukkitRunnable(){
            int timer = 100;
            int beepFrequency = 12;
            int beepCounter = 0;

            public void run() {
                if (pd.isRemoved() || !pd.isSpawned().booleanValue()) {
                    this.cancel();
                    return;
                }
                --this.timer;
                if (this.timer <= 0) {
                    C4Player.this.handleExplosion(pd);
                    this.cancel();
                    return;
                }
                if (this.timer % 10 == 0 && this.beepFrequency > 1) {
                    --this.beepFrequency;
                }
                ++this.beepCounter;
                if (this.beepCounter >= this.beepFrequency) {
                    ZombiEraCore.getSoundManager().playSound(pd.getLocation(), "c4beep");
                    this.beepCounter = 0;
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 3L);
    }

    private void handleExplosion(PropData pd) {
        ZDoor zDoor;
        Block doorBlock = (Block)pd.getPropMetaData("block");
        if (doorBlock != null && (zDoor = ZombiEraCore.getDoorManager().getDoorAtBlock(doorBlock)) != null && zDoor.getType() == DoorTypes.PLAYER) {
            ZombiEraCore.getDoorManager().removeLockedDoor(zDoor);
            Door doorData = (Door)zDoor.getLocation().getBlock().getBlockData();
            doorData.setOpen(true);
            zDoor.getLocation().getBlock().setBlockData((BlockData)doorData);
        }
        pd.getLocation().createExplosion(1.0f, false, false);
        pd.deSpawn();
        pd.remove();
    }

    @Override
    public void stopBehaviour(PropData pd) {
    }
}

