/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.player;

import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONObject;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.PropTickHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.remote.database.handlers.DBBlocksHandler;
import zombieworldproject.zombieracore.remote.database.handlers.DBPropHandler;
import zombieworldproject.zombieracore.remote.database.views.BlockView;

public class LandClaimerProp
implements PropHandler,
PropTickHandler {
    public static final double CLAIM_RADIUS = 30.0;
    private static final int MAX_HITS_TO_REMOVE = 10;
    private static final int HIT_RESET_DELAY_TICKS = 1200;

    public static PropData isClaimed(Location location) {
        if (location == null) {
            return null;
        }
        for (Entity entity : location.getNearbyEntitiesByType(ArmorStand.class, 34.0, 34.0, 34.0)) {
            PropData pd = ZombiEraCore.getPropManager().propDataMap.get(entity.getEntityId());
            if (pd == null || pd.prop == null || !(pd.prop.getPropHandler() instanceof LandClaimerProp)) continue;
            return pd;
        }
        return null;
    }

    @Override
    public void runBehaviour(PropData pd) {
    }

    @Override
    public void stopBehaviour(PropData pd) {
    }

    @Override
    public void handleClick(boolean isRightClick, final PropData propData, Player player) {
        if (isRightClick || propData == null || player == null) {
            return;
        }
        int currentHits = (Integer)propData.getPropMetaData("hit", 0);
        int newHitCount = currentHits + 1;
        new BukkitRunnable(){

            public void run() {
                if (!propData.isRemoved()) {
                    propData.setPropMetaData("hit", 0);
                }
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 1200L);
        if (newHitCount >= 10) {
            this.removeClaim(propData, player);
        } else {
            propData.setPropMetaData("hit", newHitCount);
        }
    }

    private void removeClaim(PropData propData, Player player) {
        UUID uuid;
        JSONObject database = (JSONObject)propData.getPropMetaData("database");
        if (database == null) {
            ZombiEraCore.debugInfo("[LandClaimerProp] Database JSON is null.");
            return;
        }
        String playerUUID = (String)database.get((Object)"player");
        if (playerUUID == null) {
            ZombiEraCore.debugInfo("[LandClaimerProp] Player UUID missing from database JSON.");
            return;
        }
        try {
            uuid = UUID.fromString(playerUUID);
        }
        catch (IllegalArgumentException e) {
            ZombiEraCore.debugInfo("[LandClaimerProp] Invalid UUID format: " + playerUUID);
            return;
        }
        ZombiEraCore.getDoorManager().removeAllDoorsForPlayer(Bukkit.getOfflinePlayer((UUID)uuid));
        List<BlockView> blocks = DBBlocksHandler.getAllBlocksByData(playerUUID);
        if (blocks != null && !blocks.isEmpty()) {
            for (BlockView block : blocks) {
                Location loc = new Location(Bukkit.getWorld((String)block.getWorld()), (double)block.getX(), (double)block.getY(), (double)block.getZ());
                if (loc.getBlock() == null || loc.getBlock().getType() == Material.AIR) continue;
                loc.getBlock().setType(Material.AIR);
            }
        }
        DBBlocksHandler.deleteAllByData(playerUUID);
        DBPropHandler.deleteAllBaseBuildingPropsForPlayer(player);
        PlayerInventory inv = player.getInventory();
        inv.addItem(new ItemStack[]{ZombiEraCore.getItemManager().getItemBase("landclaimer").getItem()});
        propData.remove();
        ZombiEraCore.playerInfo(player, "Your land claim has been removed.");
    }
}

