/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.player;

import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONObject;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.PropTickHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.DefaultLootAbleProp;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.remote.database.handlers.DBPropHandler;
import zombieworldproject.zombieracore.remote.database.views.PropDataView;

public class StorageProp
extends DefaultLootAbleProp
implements PropHandler,
PropTickHandler {
    @Override
    public void runBehaviour(final PropData pd) {
        new BukkitRunnable(){

            public void run() {
                if (pd == null || pd.getPropMetaData("loaded") != null) {
                    return;
                }
                pd.setPropMetaData("loaded", true);
                JSONObject dbData = (JSONObject)pd.getPropMetaData("database");
                if (dbData == null) {
                    ZombiEraCore.debugInfo("[StorageProp] No database object found for " + String.valueOf(pd));
                    return;
                }
                JSONObject storage = (JSONObject)dbData.get((Object)"storage");
                if (storage == null) {
                    ZombiEraCore.debugInfo("[StorageProp] No storage data found in DB object");
                    return;
                }
                try {
                    Inventory inv = ItemUtils.deserializeInventory(storage.toJSONString());
                    if (inv != null) {
                        pd.getLootAblePropData().setInventory(Arrays.asList(inv.getContents()));
                    }
                }
                catch (Exception e) {
                    ZombiEraCore.debugInfo("[StorageProp] Failed to deserialize storage: " + e.getMessage());
                }
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 5L);
    }

    @Override
    public void stopBehaviour(PropData pd) {
        this.saveToDatabase(pd);
    }

    @Override
    public void handleClick(boolean isRightClick, PropData pd, Player player) {
        if (!isRightClick || player == null || pd == null) {
            return;
        }
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (ph.isUsingItem().booleanValue()) {
            return;
        }
        PlayerInventory playerInventory = player.getInventory();
        ItemStack itemInHand = playerInventory.getItemInMainHand();
        if (this.isBuildHammer(itemInHand)) {
            if (pd.getLootAblePropData().getInventory().isEmpty()) {
                playerInventory.addItem(new ItemStack[]{ZombiEraCore.getItemManager().getItemBase("playerstorage").getItem()});
                pd.remove();
            } else {
                ZombiEraCore.playerInfo(player, "You can't pick up a storage with items inside!");
                ph.startUsingItem(20);
            }
            return;
        }
        if (pd.isLootAble().booleanValue()) {
            pd.getLootAblePropData().openInventory(player);
        }
    }

    private boolean isBuildHammer(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData()) {
            return false;
        }
        int nbt = item.getItemMeta().getCustomModelData();
        ItemBase base = ZombiEraCore.getItemManager().getItemBase(nbt);
        return base != null && "buildhammer".equalsIgnoreCase(base.getDirName());
    }

    @Override
    public void onInventoryOpen(PropData pd) {
        ZombiEraCore.debugInfo("[StorageProp] Inventory opened for prop ID: " + ZombiEraCore.getPropManager().getPropId(pd));
    }

    @Override
    public void onInventoryClose(InventoryCloseEvent event, PropData pd) {
        ZombiEraCore.debugInfo("[StorageProp] Inventory closed \u2014 saving to DB...");
        this.saveToDatabase(pd);
    }

    private void saveToDatabase(PropData pd) {
        if (pd == null || !pd.isSpawned().booleanValue()) {
            return;
        }
        JSONObject dbData = (JSONObject)pd.getPropMetaData("database");
        if (dbData == null) {
            ZombiEraCore.debugInfo("[StorageProp] Cannot save \u2014 missing database object!");
            return;
        }
        try {
            JSONObject storage = ItemUtils.serializeInventory(pd.getLootAblePropData().getInventory());
            dbData.put((Object)"storage", (Object)storage);
            PropDataView pdv = new PropDataView();
            pdv.setId(ZombiEraCore.getPropManager().getPropId(pd));
            pdv.setMetadata(dbData);
            DBPropHandler.updatePropMetaData(pdv);
        }
        catch (Exception e) {
            ZombiEraCore.debugInfo("[StorageProp] Failed to save storage to DB: " + e.getMessage());
        }
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event, PropData pd) {
        if (event != null && pd != null) {
            ZombiEraCore.debugInfo("[StorageProp] Inventory clicked: " + event.getSlot());
        }
    }
}

