/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.server;

import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.PropTickHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.BlockUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class AirBomb
implements PropHandler,
PropTickHandler {
    private static final int FIRE_RADIUS = 10;
    private static final int FIRE_SPREAD_CHANCE = 50;
    private static final int EXPLOSION_RADIUS = 5;
    private static final int NUM_EXPLOSIONS = 5;

    private void triggerExplosionFire(Location center) {
        if (center == null || center.getWorld() == null) {
            return;
        }
        World world = center.getWorld();
        HashSet<Location> fireLocations = new HashSet<Location>();
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                for (int y = -3; y <= 3; ++y) {
                    Block below;
                    Block block;
                    Location loc = center.clone().add((double)x, (double)y, (double)z);
                    if (loc.distanceSquared(center) > 100.0 || (block = world.getBlockAt(loc)).getType() != Material.AIR || !(below = block.getRelative(0, -1, 0)).getType().isSolid() || MiscUtils.globalRandom.nextInt(100) >= 50) continue;
                    fireLocations.add(loc);
                }
            }
        }
        Bukkit.getScheduler().runTask((Plugin)ZombiEraCore.instance, () -> fireLocations.forEach(l -> l.getBlock().setType(Material.FIRE, false)));
    }

    @Override
    public void runBehaviour(final PropData pd) {
        if (pd == null || pd.isRemoved()) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (!pd.isTicking().booleanValue() || pd.isRemoved()) {
                    this.cancel();
                    return;
                }
                final Location loc = pd.getLocation();
                if (loc == null || loc.getWorld() == null) {
                    pd.remove();
                    this.cancel();
                    return;
                }
                if (loc.getBlock().getType() == Material.AIR) {
                    pd.setLocationWithChunk(loc.add(0.0, -1.0, 0.0));
                    return;
                }
                ZombiEraCore.getSoundManager().playSound(loc, "bomb", (Double)400.0);
                if (MiscUtils.generateChange(20.0f)) {
                    AirBomb.this.triggerExplosionFire(loc);
                }
                if (MiscUtils.generateChange(20.0f)) {
                    BlockUtils.detectAndLaunchBlocks(loc, 3, 60L);
                }
                new BukkitRunnable(){
                    int count = 0;
                    final int targetCount = MiscUtils.globalRandom.nextInt(2, 5);

                    public void run() {
                        if (pd.isRemoved() || this.count >= this.targetCount) {
                            this.cancel();
                            return;
                        }
                        double xOffset = (MiscUtils.globalRandom.nextDouble() * 2.0 - 1.0) * 5.0;
                        double yOffset = Math.abs(MiscUtils.globalRandom.nextDouble()) * 5.0;
                        double zOffset = (MiscUtils.globalRandom.nextDouble() * 2.0 - 1.0) * 5.0;
                        Location explosionLoc = loc.clone().add(xOffset, yOffset, zOffset);
                        if (explosionLoc.getY() > loc.getY()) {
                            explosionLoc.getWorld().createExplosion(explosionLoc, 4.0f, false, false);
                            ++this.count;
                        }
                    }
                }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 2L);
                pd.remove();
                this.cancel();
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 2L);
    }

    @Override
    public void stopBehaviour(PropData pd) {
    }
}

