/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.server;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.BodyPart;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.BulletResult;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.props.PropCollisionHandler;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class BearTrapOpened
implements PropHandler,
PropCollisionHandler {
    @Override
    public void handleClick(boolean isRightClick, final PropData propData, final Player player) {
        if (!isRightClick || propData == null || player == null) {
            return;
        }
        final String currentDir = propData.getLastPropItemDirname();
        if (currentDir == null || currentDir.equals("bear_trap_opened")) {
            return;
        }
        final PlayerHealth health = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (health == null || health.isUsingItem().booleanValue()) {
            return;
        }
        health.startUsingItem();
        final Location startLoc = player.getLocation().clone();
        final int[] ticks = new int[]{0};
        new BukkitRunnable(){

            public void run() {
                if (!player.isOnline() || propData.isRemoved()) {
                    this.cancel();
                    return;
                }
                Location now = player.getLocation();
                if (now.getBlockX() != startLoc.getBlockX() || now.getBlockY() != startLoc.getBlockY() || now.getBlockZ() != startLoc.getBlockZ()) {
                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Action interrupted!", 5);
                    health.stopUsingItem();
                    this.cancel();
                    return;
                }
                if (ticks[0] >= 60) {
                    if ("bear_trap_closed".equals(currentDir)) {
                        propData.setItem(ZombiEraCore.getPropManager().getPropByDirName("bear_trap_opened"));
                    }
                    health.stopUsingItem();
                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Bear trap set!", 5);
                    this.cancel();
                    return;
                }
                if (ticks[0] % 10 == 0) {
                    int dots = ticks[0] / 10 % 3 + 1;
                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Setting trap" + ".".repeat(dots), 5);
                }
                ticks[0] = ticks[0] + 1;
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 1L);
    }

    @Override
    public void onBulletHit(Entity entityDamager, BulletResult result, PropData propData) {
        if (propData == null || result == null) {
            return;
        }
        String dir = propData.getLastPropItemDirname();
        if (dir == null) {
            return;
        }
        if (result.bodyPart == BodyPart.LEG && dir.equals("bear_trap_opened")) {
            if (propData.location != null) {
                ZombiEraCore.getSoundManager().playSound(propData.location, "bear_trap_open");
            }
            propData.setItem(ZombiEraCore.getPropManager().getPropByDirName("bear_trap_closed"));
        }
    }

    @Override
    public void onCollision(PropData propData, LivingEntity collidedEntity) {
        if (propData == null || collidedEntity == null) {
            return;
        }
        String dir = propData.getLastPropItemDirname();
        if (dir == null || !dir.equals("bear_trap_opened")) {
            return;
        }
        if (propData.location != null) {
            ZombiEraCore.getSoundManager().playSound(propData.location, "bear_trap_open");
        }
        propData.setItem(ZombiEraCore.getPropManager().getPropByDirName("bear_trap_closed"));
        if (collidedEntity instanceof Player) {
            Player player = (Player)collidedEntity;
            PlayerHealth health = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
            if (health != null) {
                health.setRandomLegBleeding();
                if (MiscUtils.generateChange(50.0f)) {
                    health.setRandomLegBroken();
                }
            }
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 60, 10, false, false));
        } else {
            collidedEntity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 120, 10, false, false));
        }
        collidedEntity.damage(12.0);
    }

    @Override
    public Double getCollisionSphereSize() {
        return 0.5;
    }
}

