/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.server;

import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.PropBase;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.data.ChunkPropsData;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ClosedCorpseBag
implements PropHandler {
    @Override
    public void handleClick(boolean isRightClick, PropData propData, Player player) {
        if (!isRightClick || propData == null || player == null) {
            return;
        }
        ArmorStand as = propData.getArmorStand();
        if (as == null || as.isDead()) {
            return;
        }
        Location location = as.getLocation();
        if (location == null || location.getWorld() == null) {
            return;
        }
        Chunk chunk = location.getChunk();
        ChunkPropsData cpd = ZombiEraCore.getPropManager().getChunkPropsData(chunk.getX(), chunk.getZ(), chunk.getWorld());
        if (cpd == null) {
            return;
        }
        if (propData.isRemoved()) {
            return;
        }
        boolean removed = cpd.removePropByEntityId(as.getEntityId());
        if (!removed) {
            return;
        }
        PropBase openedCorpseBag = ZombiEraCore.getPropManager().getPropByDirName("dead_corpse_bag_opened");
        if (openedCorpseBag == null) {
            ZombiEraCore.debugInfo("ClosedCorpseBag: missing prop 'dead_corpse_bag_opened'.");
            return;
        }
        if (MiscUtils.generateChance(50)) {
            ZombiEraCore.getEntityManager().summonEntity("walker", location);
        }
        cpd.addPropNow(openedCorpseBag, location);
    }
}

