/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.server;

import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.GasCanister;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.Lighter;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class GasPump
implements PropHandler {
    @Override
    public void handleClick(boolean isRightClick, PropData propData, Player player) {
        ItemStack canisterItem;
        if (!isRightClick || propData == null || player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack handItem = inventory.getItemInMainHand();
        if (handItem == null || !handItem.hasItemMeta() || !handItem.getItemMeta().hasCustomModelData()) {
            return;
        }
        Integer nbtId = handItem.getItemMeta().getCustomModelData();
        World world = player.getWorld();
        GasCanister gasCanister = (GasCanister)ZombiEraCore.getItemManager().usableItems.get("gascanister");
        if (gasCanister != null && (canisterItem = gasCanister.getItem()) != null && nbtId.equals(canisterItem.getItemMeta().getCustomModelData())) {
            this.startFillingGas(player, handItem, gasCanister, propData);
            return;
        }
        if (nbtId.equals(Lighter.NBTTag)) {
            this.igniteGasPump(player, handItem, propData);
        }
    }

    private void startFillingGas(final Player player, final ItemStack canister, final GasCanister gasCanister, final PropData propData) {
        final Location startLocation = player.getLocation().clone();
        final PlayerInventory inventory = player.getInventory();
        final int usableId = canister.getItemMeta().getCustomModelData();
        final int[] tickCount = new int[]{1};
        final PlayerHealth playerHealth = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (playerHealth == null) {
            return;
        }
        playerHealth.startUsingItem();
        final World world = player.getWorld();
        world.playSound(player.getLocation(), Sound.UI_TOAST_IN, 1.0f, 1.0f);
        new BukkitRunnable(){

            public void run() {
                if (!player.isOnline() || propData.isRemoved()) {
                    playerHealth.stopUsingItem();
                    this.cancel();
                    return;
                }
                if (!UsableItemBase.isSameItem(usableId, inventory) || !GasPump.this.sameBlockLocation(player.getLocation(), startLocation)) {
                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Filling interrupted!", 5);
                    world.playSound(player.getLocation(), Sound.BLOCK_CANDLE_HIT, 1.0f, 1.0f);
                    playerHealth.stopUsingItem();
                    this.cancel();
                    return;
                }
                Integer currentCapacity = ItemUtils.getCapacity(canister);
                if (currentCapacity >= gasCanister.MaxGasCapacity) {
                    world.playSound(player.getLocation(), Sound.UI_TOAST_OUT, 1.0f, 1.0f);
                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Gas canister fully filled!", 5);
                    playerHealth.stopUsingItem();
                    this.cancel();
                    return;
                }
                ItemUtils.addCapacity(canister, 1);
                tickCount[0] = tickCount[0] + 1;
                if (tickCount[0] % 5 == 0) {
                    int dots = tickCount[0] / 5 % 3 + 1;
                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Filling" + ".".repeat(dots), 5);
                }
                if (tickCount[0] >= gasCanister.MaxGasCapacity) {
                    world.playSound(player.getLocation(), Sound.UI_TOAST_OUT, 1.0f, 1.0f);
                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Gas canister fully filled!", 5);
                    playerHealth.stopUsingItem();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 1L);
    }

    private void igniteGasPump(Player player, ItemStack lighterItem, final PropData propData) {
        int capacity = ItemUtils.getCapacity(lighterItem);
        if (capacity <= 0) {
            return;
        }
        Location location = player.getLocation();
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.createExplosion(location.getX(), location.getY(), location.getZ(), 2.0f, true, false);
        ItemUtils.setCapacity(lighterItem, capacity - 1);
        ZombiEraCore.playerInfo(player, "( \u0361\u00b0 \u035c\u0296 \u0361\u00b0) Not a good idea to set a gas pump on fire.");
        propData.deSpawn();
        new BukkitRunnable(){

            public void run() {
                if (!propData.isSpawned().booleanValue() && propData.getChunkPropsData() != null && propData.getChunkPropsData().isActive()) {
                    propData.spawn();
                }
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 4000L);
    }

    private boolean sameBlockLocation(Location a, Location b) {
        return a.getBlockX() == b.getBlockX() && a.getBlockY() == b.getBlockY() && a.getBlockZ() == b.getBlockZ();
    }
}

