/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.server;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.PropCollisionHandler;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;

public class Landmine
implements PropHandler,
PropCollisionHandler {
    private static final float EXPLOSION_POWER = 4.0f;
    private static final boolean SET_FIRE = false;
    private static final boolean BREAK_BLOCKS = false;
    private static final long RESPAWN_DELAY_TICKS = 6000L;

    @Override
    public void onCollision(final PropData propData, LivingEntity collidedEntity) {
        if (propData == null || collidedEntity == null) {
            return;
        }
        Location location = propData.getLocation();
        if (location == null) {
            return;
        }
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.createExplosion(location, 4.0f, false, false);
        propData.deSpawn();
        new BukkitRunnable(){

            public void run() {
                if (propData.isRemoved()) {
                    this.cancel();
                    return;
                }
                if (propData.getChunkPropsData() != null && propData.getChunkPropsData().isActive() && !propData.isSpawned().booleanValue()) {
                    propData.spawn();
                }
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 6000L);
    }

    @Override
    public Double getCollisionSphereSize() {
        return 0.5;
    }
}

