/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.server;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.ZERarityDropManager;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.LuckyChestKey;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.PropTickHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.DefaultLootAbleProp;

public class LuckyChest
extends DefaultLootAbleProp
implements PropHandler,
PropTickHandler {
    @Override
    public void runBehaviour(PropData pd) {
        pd.setPropMetaData("opened", false);
        pd.setPropMetaData("inv", Bukkit.createInventory(null, (int)9, (String)("p" + pd.getArmorStand().getEntityId())));
        PropData questionMark = ZombiEraCore.getPropManager().addPropToWorldNotSaved(ZombiEraCore.getPropManager().getPropByDirName("luckychest_question"), pd.getLocation().clone());
        pd.setPropMetaData("question_mark", questionMark);
    }

    @Override
    public void stopBehaviour(PropData pd) {
        PropData pdQ = (PropData)pd.getPropMetaData("question_mark");
        if (pdQ != null && pdQ.isSpawned().booleanValue()) {
            pdQ.deSpawn();
        }
    }

    @Override
    public void handleClick(boolean isRightClick, PropData propData, Player player) {
        if (!isRightClick) {
            return;
        }
        Boolean isOpened = (Boolean)propData.getPropMetaData("opened");
        if (!isOpened.booleanValue()) {
            if (this.useLuckyChestKey(player)) {
                propData.setPropMetaData("opened", true);
                this.onInventoryOpen(propData, player);
            } else {
                ZombiEraCore.getSoundManager().playSound(player, "luckychest_error");
                ZombiEraCore.playerInfo(player, "You need to hold lucky chest key in your hand!");
            }
        } else {
            ZombiEraCore.playerInfo(player, "This chest is already in use!");
        }
    }

    public boolean useLuckyChestKey(Player player) {
        int id;
        ItemStack main = player.getInventory().getItemInMainHand();
        if (main != null && main.hasItemMeta() && main.getItemMeta().hasCustomModelData() && (id = main.getItemMeta().getCustomModelData()) == LuckyChestKey.NBTId) {
            player.getInventory().setItemInMainHand(null);
            return true;
        }
        return false;
    }

    public void onInventoryOpen(final PropData pd, final Player player) {
        Inventory inventory = (Inventory)pd.getPropMetaData("inv");
        inventory.clear();
        player.openInventory(inventory);
        pd.setItem(ZombiEraCore.getPropManager().getPropByDirName("luckychest_open"));
        ZombiEraCore.getSoundManager().playSound(player.getLocation(), "luckychest_open");
        ZombiEraCore.getSoundManager().playSound(player.getLocation(), "luckychest_generate");
        new BukkitRunnable(){
            final Inventory inventory;
            final ZERarityDropManager.RarityGroup rarityGroup;
            Integer counter;
            Integer slotCounter;
            {
                this.inventory = (Inventory)pd.getPropMetaData("inv");
                this.rarityGroup = pd.getLootAblePropData().getLootGroup();
                this.counter = 0;
                this.slotCounter = 0;
            }

            public void run() {
                this.counter = this.counter + 1;
                if (this.slotCounter < 9) {
                    this.inventory.setItem(this.slotCounter.intValue(), this.rarityGroup.generateItemStacks().get(0));
                    this.slotCounter = this.slotCounter + 1;
                } else if (this.counter > 100) {
                    new BukkitRunnable(){
                        Integer counter2 = 0;
                        Integer maxLoops = 0;
                        Boolean doIt = false;

                        public void run() {
                            this.counter2 = this.counter2 + 1;
                            if (this.counter2 % 3 == 0) {
                                this.doIt = true;
                            }
                            if (this.doIt.booleanValue() && this.maxLoops < 4) {
                                this.doIt = false;
                                inventory.setItem(8 - this.maxLoops, new ItemStack(Material.LIME_STAINED_GLASS_PANE));
                                inventory.setItem(this.maxLoops.intValue(), new ItemStack(Material.LIME_STAINED_GLASS_PANE));
                                this.maxLoops = this.maxLoops + 1;
                            } else if (this.maxLoops == 4) {
                                this.cancel();
                                final ItemStack itemToGive = inventory.getItem(4);
                                new BukkitRunnable(){

                                    public void run() {
                                        player.getInventory().addItem(new ItemStack[]{itemToGive});
                                        pd.setPropMetaData("opened", false);
                                        pd.setItem(ZombiEraCore.getPropManager().getPropByDirName("luckychest_closed"));
                                        ZombiEraCore.getSoundManager().playSound(player, "luckychest_close");
                                        player.closeInventory();
                                    }
                                }.runTaskLater((Plugin)ZombiEraCore.instance, 40L);
                            }
                        }
                    }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
                    this.cancel();
                } else if (this.slotCounter == 9) {
                    this.slotCounter = 0;
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
    }

    @Override
    public void onInventoryClose(final InventoryCloseEvent event, PropData pd) {
        Boolean isOpened = (Boolean)pd.getPropMetaData("opened");
        if (isOpened.booleanValue()) {
            new BukkitRunnable(){

                public void run() {
                    event.getPlayer().openInventory(event.getInventory());
                }
            }.runTaskLater((Plugin)ZombiEraCore.instance, 1L);
        }
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event, PropData pd) {
        ZombiEraCore.debugInfo("event");
        event.setCancelled(true);
    }
}

