/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.server;

import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.BulletResult;
import zombieworldproject.zombieracore.managers.player.states.HealthStates;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.PropTickHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class SewerSporeEgg
implements PropHandler,
PropTickHandler {
    private static final double SOUND_DISTANCE = 12.0;
    private static final int INFECTION_RADIUS = 4;

    @Override
    public void onBulletHit(Entity entityDamager, BulletResult result, PropData propData) {
        if (propData == null) {
            return;
        }
        if (!"sewers_egg_05".equals(propData.getLastPropItemDirname())) {
            propData.resetTimer();
            propData.setItem(ZombiEraCore.getPropManager().getPropByDirName("sewers_egg_04"));
            propData.ticksNow = 20;
        }
    }

    @Override
    public void runBehaviour(final PropData pd) {
        if (pd == null || pd.location == null) {
            return;
        }
        final World world = pd.location.getWorld();
        if (world == null) {
            return;
        }
        final Block aboveBlock = pd.location.getBlock().getRelative(BlockFace.UP);
        aboveBlock.setType(Material.LIGHT, false);
        final Levelled lightLevel = (Levelled)aboveBlock.getBlockData();
        lightLevel.setLevel(0);
        aboveBlock.setBlockData((BlockData)lightLevel, true);
        new BukkitRunnable(){

            public void run() {
                if (!pd.isTicking().booleanValue() || world == null) {
                    pd.setLastPropItemDirname("sewers_egg_01");
                    this.cancel();
                    return;
                }
                if (pd.ticksNow % 4 == 0 && !"sewers_egg_05".equals(pd.getLastPropItemDirname())) {
                    ZombiEraCore.getSoundManager().playSound(pd.location, "sewers_egg", (Double)12.0);
                }
                switch (pd.getLastPropItemDirname()) {
                    case "sewers_egg_01": {
                        SewerSporeEgg.this.handleStage(pd, aboveBlock, lightLevel, "sewers_egg_02", 2, Sound.ENTITY_CREEPER_HURT, 2);
                        break;
                    }
                    case "sewers_egg_02": {
                        SewerSporeEgg.this.handleStage(pd, aboveBlock, lightLevel, "sewers_egg_03", 6, Sound.ENTITY_CREEPER_HURT, 4);
                        break;
                    }
                    case "sewers_egg_03": {
                        SewerSporeEgg.this.handleStage(pd, aboveBlock, lightLevel, "sewers_egg_04", 10, Sound.ENTITY_CREEPER_HURT, 10);
                        break;
                    }
                    case "sewers_egg_04": {
                        if (pd.ticksNow != 20) break;
                        SewerSporeEgg.this.explodeAndInfect(pd, aboveBlock, lightLevel, world);
                    }
                }
                Object object = pd;
                Integer n = ((PropData)object).ticksNow;
                ((PropData)object).ticksNow = ((PropData)object).ticksNow + 1;
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, (long)(MiscUtils.globalRandom.nextInt(40) + 1), 10L);
    }

    private void handleStage(PropData pd, Block lightBlock, Levelled lightLevel, String nextStage, int newLightLevel, Sound sound, int requiredTicks) {
        if (pd.ticksNow == requiredTicks) {
            lightLevel.setLevel(newLightLevel);
            lightBlock.setBlockData((BlockData)lightLevel, true);
            pd.setItem(ZombiEraCore.getPropManager().getPropByDirName(nextStage));
            ZombiEraCore.getSoundManager().playSound(pd.location, sound, (Double)12.0, Float.valueOf(1.5f));
        }
    }

    private void explodeAndInfect(final PropData pd, Block lightBlock, Levelled lightLevel, World world) {
        lightLevel.setLevel(0);
        lightBlock.setBlockData((BlockData)lightLevel, true);
        pd.setItem(ZombiEraCore.getPropManager().getPropByDirName("sewers_egg_05"));
        ZombiEraCore.getSoundManager().playSound(pd.location, Sound.ENTITY_CREEPER_HURT, (Double)12.0, Float.valueOf(1.5f));
        ZombiEraCore.getSoundManager().playSound(pd.location, Sound.ENTITY_GENERIC_EXPLODE, (Double)15.0);
        world.spawnParticle(Particle.EXPLOSION_LARGE, pd.location, 1);
        this.spawnSporeParticles(world, pd.location);
        this.infectNearbyPlayers(world, pd.location);
        new BukkitRunnable(){

            public void run() {
                pd.resetTimer();
                pd.setItem(ZombiEraCore.getPropManager().getPropByDirName("sewers_egg_01"));
                ZombiEraCore.getSoundManager().playSound(pd.location, Sound.ENTITY_CREEPER_HURT, (Double)12.0, Float.valueOf(1.5f));
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 120L);
    }

    private void spawnSporeParticles(World world, Location baseLoc) {
        for (int i = 0; i < 10; ++i) {
            Location loc = baseLoc.clone().add((double)(MiscUtils.globalRandom.nextInt(3) * MiscUtils.randomNegativePositiveInt()), 0.5, (double)(MiscUtils.globalRandom.nextInt(3) * MiscUtils.randomNegativePositiveInt()));
            Particle.DustTransition spores = new Particle.DustTransition(Color.fromRGB((int)0, (int)255, (int)0), Color.fromRGB((int)144, (int)238, (int)144), 1.0f);
            for (int j = 0; j < 3; ++j) {
                world.spawnParticle(Particle.DUST_COLOR_TRANSITION, loc.clone().add(0.0, 0.5 * (double)j, 0.0), 30, (Object)spores);
            }
        }
    }

    private void infectNearbyPlayers(World world, Location source) {
        List nearby = world.getNearbyEntities(source, 12.0, 2.0, 12.0).stream().toList();
        for (Entity entity : nearby) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            double dist = player.getLocation().distance(source);
            if (dist <= 4.0) {
                ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).setInfection(HealthStates.INFECTION, true);
                player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 120, 1));
            }
            ZombiEraCore.getSoundManager().stopSoundAtPlayer(player, "sewers_egg");
        }
    }

    @Override
    public void stopBehaviour(PropData pd) {
    }
}

