/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.server;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.PropTickHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.DefaultLootAbleProp;

public class SupplyDrop
extends DefaultLootAbleProp
implements PropTickHandler {
    private static final int DROP_LIFETIME_TICKS = 72000;
    private static final int PLANE_FLIGHT_TICKS = 800;
    private static final int DROP_START_TICK = 400;
    private static final double COLLISION_RADIUS = 0.75;
    private static final double PUSH_FORCE = 0.5;

    @Override
    public void runBehaviour(final PropData pd) {
        if (pd == null || pd.propMetaData.containsKey("active")) {
            return;
        }
        pd.setPropMetaData("active", true);
        pd.setLocationWithChunk(pd.getLocation());
        pd.getLootAblePropData().setLootOnlyOnce(true);
        pd.setItem(new ItemStack(Material.AIR));
        ArmorStand armorStand = pd.getArmorStand();
        EulerAngle neutralAngle = new EulerAngle(0.0, 0.0, 0.0);
        armorStand.setHeadPose(neutralAngle);
        armorStand.setBodyPose(neutralAngle);
        pd.setLocation(pd.getLocation().setDirection(new Vector(0, 0, 1)));
        new BukkitRunnable(){

            public void run() {
                pd.remove();
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 72000L);
        if (!"supplydrop_parachute".equals(pd.getLastPropItemDirname())) {
            this.startPlaneSequence(pd);
        }
    }

    private void startPlaneSequence(final PropData pd) {
        Location planeLoc = pd.getLocation().clone().add(200.0, 0.0, 0.0);
        if (!planeLoc.getChunk().isLoaded()) {
            planeLoc.getChunk().load(true);
        }
        final PropData pdPlane = ZombiEraCore.getPropManager().addPropToWorldNotSaved(ZombiEraCore.getPropManager().getPropByDirName("plane"), planeLoc);
        pdPlane.setLocationWithChunk(pdPlane.getLocation());
        new BukkitRunnable(){
            int tick = 0;

            public void run() {
                if (this.tick <= 800) {
                    pdPlane.setLocationWithChunk(pdPlane.getLocation().add(-0.5, 0.0, 0.0));
                    if (this.tick == 400) {
                        SupplyDrop.this.supplyDropFall(pd);
                        SupplyDrop.this.supplyDropCollision(pd);
                    }
                    ++this.tick;
                } else {
                    pdPlane.remove();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 1L);
    }

    private void supplyDropFall(final PropData pd) {
        new BukkitRunnable(){

            public void run() {
                if (pd.isRemoved()) {
                    this.cancel();
                    return;
                }
                Location loc = pd.getLocation();
                if (loc.getBlock().getRelative(BlockFace.DOWN).isSolid()) {
                    pd.setLocation(loc.add(0.0, -0.5, 0.0));
                    pd.setItem(ZombiEraCore.getPropManager().getPropByDirName("loot_supplydrop_closed"));
                    pd.getLocation().getChunk().unload();
                    this.cancel();
                } else {
                    if (!"supplydrop_parachute".equals(pd.getLastPropItemDirname())) {
                        pd.setItem(ZombiEraCore.getPropManager().getPropByDirName("supplydrop_parachute"));
                    }
                    pd.setLocation(loc.add(0.0, -0.5, 0.0));
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 20L);
    }

    private void supplyDropCollision(final PropData pd) {
        new BukkitRunnable(){

            public void run() {
                if (pd.isRemoved()) {
                    this.cancel();
                    return;
                }
                List players = pd.getLocation().getNearbyPlayers(0.75).stream().toList();
                for (Player player : players) {
                    try {
                        Vector push = player.getLocation().toVector().subtract(pd.location.toVector()).normalize().multiply(0.5);
                        player.setVelocity(push);
                    }
                    catch (Exception exception) {}
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 5L);
    }

    @Override
    public void handleClick(boolean isRightClick, PropData propData, Player player) {
        if (!isRightClick || propData == null || player == null) {
            return;
        }
        if (!"supplydrop_parachute".equals(propData.getLastPropItemDirname()) && propData.isLootAble().booleanValue()) {
            propData.getLootAblePropData().openInventory(player);
        }
    }

    @Override
    public void onInventoryClose(InventoryCloseEvent event, PropData pd) {
        if (pd == null || pd.getLootAblePropData() == null) {
            return;
        }
        if (pd.getLootAblePropData().getInventory().isEmpty()) {
            pd.deSpawn();
            pd.remove();
        }
    }

    @Override
    public void stopBehaviour(PropData pd) {
    }
}

