/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.server;

import java.util.Comparator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.gun.bullet.AmmoTypes;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.PropTickHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;

public class Turret
implements PropHandler,
PropTickHandler {
    private static final double DETECTION_RADIUS_XZ = 17.0;
    private static final double DETECTION_RADIUS_Y = 3.0;
    private static final int FIRE_RATE_TICKS = 5;

    @Override
    public void runBehaviour(final PropData pd) {
        if (pd == null || pd.location == null) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (!pd.isTicking().booleanValue()) {
                    this.cancel();
                    return;
                }
                LivingEntity target = Turret.this.findNearestTarget(pd);
                if (target == null || target.isDead()) {
                    return;
                }
                Turret.this.aimTurretAtTarget(pd, target.getLocation());
                ZombiEraCore.getItemManager().getShootHandler(AmmoTypes.RIFLE).shootTurret(pd);
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 5L);
    }

    private LivingEntity findNearestTarget(PropData pd) {
        List<Entity> nearby = pd.getLocation().getNearbyEntities(17.0, 3.0, 17.0).stream().filter(e -> e instanceof Monster).sorted(Comparator.comparingDouble(e -> e.getLocation().distanceSquared(pd.getLocation()))).toList();
        if (nearby.isEmpty()) {
            return null;
        }
        return (LivingEntity)nearby.get(0);
    }

    private void aimTurretAtTarget(PropData pd, Location targetLocation) {
        Location turretLoc = pd.getLocation().clone();
        Vector direction = targetLocation.toVector().subtract(turretLoc.toVector()).normalize();
        float yaw = (float)Math.toDegrees(Math.atan2(-direction.getX(), direction.getZ()));
        float pitch = (float)Math.toDegrees(Math.asin(direction.getY()));
        pitch = Math.max(-45.0f, Math.min(45.0f, pitch));
        turretLoc.setYaw(yaw);
        turretLoc.setPitch(pitch);
        turretLoc.setDirection(direction);
        pd.setLocation(turretLoc);
    }

    @Override
    public void stopBehaviour(PropData pd) {
    }
}

