/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.server;

import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.item.ZEItemManager;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;

public class WaterPump
implements PropHandler {
    @Override
    public void handleClick(boolean isRightClick, PropData propData, Player player) {
        if (!isRightClick || player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack handItem = inventory.getItemInMainHand();
        if (handItem == null || handItem.getType() == Material.AIR) {
            ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).addWater(ZombiEraSettings.PLAYER_THIRST_MAX);
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Thirst quenched.", 5);
            player.playSound(player.getLocation(), Sound.ENTITY_GENERIC_DRINK, 1.0f, 1.0f);
            return;
        }
        if (handItem.hasItemMeta() && handItem.getItemMeta().hasCustomModelData()) {
            String itemName;
            int nbtId = handItem.getItemMeta().getCustomModelData();
            ZEItemManager itemManager = ZombiEraCore.getItemManager();
            ItemBase itemBase = itemManager.getItemBase(nbtId);
            if (itemBase == null) {
                return;
            }
            switch (itemName = itemBase.getDirName()) {
                case "watercanteenempty": {
                    this.fillItem(inventory, player, "watercanteenfilled");
                    break;
                }
                case "empty_water_bottle": {
                    this.fillItem(inventory, player, "clean_water_bottle");
                    break;
                }
                case "dirtyrag": {
                    this.cleanRag(inventory, player);
                    break;
                }
            }
        }
    }

    private void fillItem(PlayerInventory inventory, Player player, String newItemDirName) {
        inventory.setItemInMainHand(ZombiEraCore.getItemManager().getItemBase(newItemDirName).getItem());
        ZombiEraCore.getSoundManager().playSound(player, "liquidpour");
        ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Filled with water!", 5);
    }

    private void cleanRag(PlayerInventory inventory, Player player) {
        inventory.setItemInMainHand(ZombiEraCore.getItemManager().getItemBase("cleanrag").getItem());
        ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Rag cleaned.", 5);
    }
}

