/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.handlers.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.PropTickHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.EntityUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ZombieNest
implements PropHandler,
PropTickHandler {
    private static final int MAX_ACTIVE_ZOMBIES = 10;
    private static final int SPAWN_INTERVAL_TICKS = 10;
    private static final int KILL_COOLDOWN_TICKS = 600;
    private static final double DETECTION_RADIUS = 10.0;
    private static final double HEALTHBAR_HEIGHT = 2.0;

    @Override
    public void runBehaviour(PropData pd) {
        if (pd == null) {
            return;
        }
        Boolean alreadySpawned = (Boolean)pd.propMetaData.get("spawned");
        if (alreadySpawned != null && alreadySpawned.booleanValue()) {
            BukkitTask existing = (BukkitTask)pd.propMetaData.get("runnable");
            if (existing != null) {
                existing.cancel();
            }
            pd.setPropMetaData("runnable", this.startRunnable(pd));
            return;
        }
        pd.setPropMetaData("entities", new ArrayList());
        pd.setPropMetaData("spawned", true);
        pd.setPropMetaData("health", 100.0);
        pd.setPropMetaData("killed", 0);
        pd.setPropMetaData("healthAS", this.createOrGetHealthBar(pd));
        pd.setPropMetaData("runnable", this.startRunnable(pd));
    }

    private BukkitTask startRunnable(final PropData pd) {
        return new BukkitRunnable(){

            public void run() {
                if (!pd.isSpawned().booleanValue()) {
                    this.cancel();
                    return;
                }
                ZombieNest.this.tick(pd);
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 10L);
    }

    private void clearInvalidEntities(PropData pd) {
        List<LivingEntity> entities = this.getEntityList(pd);
        if (entities == null) {
            return;
        }
        Iterator<LivingEntity> iterator = entities.iterator();
        while (iterator.hasNext()) {
            LivingEntity entity = iterator.next();
            if (entity != null && entity.isValid() && !entity.isDead()) continue;
            iterator.remove();
            this.incrementKilled(pd);
        }
    }

    private void incrementKilled(final PropData pd) {
        Integer killed = (Integer)pd.propMetaData.get("killed");
        if (killed == null) {
            killed = 0;
        }
        pd.setPropMetaData("killed", Math.min(killed + 1, 10));
        new BukkitRunnable(){

            public void run() {
                Integer current = (Integer)pd.propMetaData.get("killed");
                if (current != null && current > 0) {
                    pd.setPropMetaData("killed", current - 1);
                }
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 600L);
    }

    private Collection<Player> getNearbyPlayers(Location location) {
        return location.getNearbyPlayers(10.0);
    }

    private void tick(PropData pd) {
        if (this.getNearbyPlayers(pd.getLocation()).isEmpty()) {
            return;
        }
        this.clearInvalidEntities(pd);
        List<LivingEntity> entities = this.getEntityList(pd);
        if (entities == null) {
            return;
        }
        Integer killed = (Integer)pd.propMetaData.get("killed");
        if (killed == null) {
            killed = 0;
        }
        if (entities.size() + killed >= 10) {
            return;
        }
        this.spawnZombie(pd, entities);
    }

    private void spawnZombie(PropData pd, List<LivingEntity> entities) {
        EntityBase base = ZombiEraCore.getEntityManager().getRandomGlobalEntityBase();
        if (base == null) {
            return;
        }
        Location spawnLoc = pd.getLocation().clone().add((double)(MiscUtils.globalRandom.nextFloat() * 3.0f * (float)MiscUtils.randomNegativePositiveInt().intValue()), -2.0, (double)(MiscUtils.globalRandom.nextFloat() * 3.0f * (float)MiscUtils.randomNegativePositiveInt().intValue()));
        LivingEntity entity = ZombiEraCore.getEntityManager().spawnEntity(base, spawnLoc);
        if (entity == null) {
            return;
        }
        entity.setAI(false);
        entity.setInvulnerable(true);
        EntityUtils.emergeEntity(entity.getLocation(), entity, 2.0);
        entities.add(entity);
    }

    private ArmorStand createOrGetHealthBar(PropData pd) {
        ArmorStand existing = (ArmorStand)pd.propMetaData.get("healthAS");
        if (existing != null && existing.isValid()) {
            return existing;
        }
        Location loc = pd.getLocation().clone().add(0.0, 2.0, 0.0);
        ArmorStand healthBar = (ArmorStand)loc.getWorld().spawn(loc, ArmorStand.class, as -> {
            as.setInvisible(true);
            as.setGravity(false);
            as.setAI(false);
            as.setCustomNameVisible(true);
        });
        healthBar.setCustomName(" ");
        return healthBar;
    }

    private List<LivingEntity> getEntityList(PropData pd) {
        return (List)pd.propMetaData.get("entities");
    }

    @Override
    public void stopBehaviour(PropData pd) {
        ArmorStand healthBar = (ArmorStand)pd.propMetaData.get("healthAS");
        if (healthBar != null && healthBar.isValid()) {
            healthBar.remove();
        }
    }

    private void spawnBoss(PropData pd) {
        EntityBase base = ZombiEraCore.getEntityManager().getEntityBaseByName("boss_sentinel");
        if (base == null) {
            return;
        }
        LivingEntity boss = ZombiEraCore.getEntityManager().spawnEntity(base, pd.getLocation().clone().add(0.0, -2.0, 0.0));
        if (boss == null) {
            return;
        }
        boss.setAI(false);
        boss.setInvulnerable(true);
        EntityUtils.emergeEntity(boss.getLocation(), boss, 2.0);
    }

    @Override
    public void handleClick(boolean isRightClick, PropData pd, Player player) {
        if (pd == null || player == null || isRightClick) {
            return;
        }
        Double health = (Double)pd.propMetaData.get("health");
        if (health == null) {
            return;
        }
        if (health <= 0.0) {
            this.spawnBoss(pd);
            pd.remove();
            return;
        }
        pd.setPropMetaData("health", health - 1.0);
        this.updateHealthBar(pd, health - 1.0);
        pd.getLocation().getWorld().playSound(pd.getLocation(), Sound.ENTITY_GOAT_HORN_BREAK, 1.0f, 1.0f);
    }

    private void updateHealthBar(PropData pd, double health) {
        ArmorStand healthBar = (ArmorStand)pd.propMetaData.get("healthAS");
        if (healthBar == null || !healthBar.isValid()) {
            healthBar = this.createOrGetHealthBar(pd);
            pd.setPropMetaData("healthAS", healthBar);
        }
        healthBar.setCustomName(health + " HP");
    }
}

