/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.items;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.door.ZDoor;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.other.Vector3;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class C4Item
extends UsableItemBase {
    public C4Item() {
        super("C4", (Integer)6780107, true);
        this.setMetaData("door", true);
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        return this.thisItem.clone();
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.MOJANG_BANNER_PATTERN);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.getRarity()), this.getName()));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Placeable");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Shift + Right click at player door to arm it!");
        meta.setLore(lore);
        meta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            ZombiEraCore.playerInfo(player, "You must sneak (use shift) to use this item on a door!");
            return;
        }
        Block clicked = event.getClickedBlock();
        if (clicked == null) {
            ZombiEraCore.playerInfo(player, "No valid block clicked!");
            return;
        }
        BlockData blockData = clicked.getBlockData();
        if (!(blockData instanceof Door)) {
            ZombiEraCore.playerInfo(player, "You can only attach C4 to a door!");
            return;
        }
        ZDoor door = ZombiEraCore.getDoorManager().getDoor(clicked);
        if (door == null) {
            ZombiEraCore.playerInfo(player, "This is not a player's door!");
            return;
        }
        Location baseLoc = door.getLocation().toBlockLocation().add(0.5, 0.0, 0.5);
        BlockFace face = ((Door)blockData).getFacing();
        Vector3 offset = this.getMoveDirection(face);
        baseLoc.add(0.5 * offset.X, 0.0, 0.5 * offset.Z);
        PropData prop = ZombiEraCore.getPropManager().addPropToChunkNow(ZombiEraCore.getPropManager().getPropByDirName("player_c4"), baseLoc);
        prop.setPropMetaData("block", clicked);
        ArmorStand stand = prop.getArmorStand();
        stand.setRotation(this.getRotationAngle(face), 0.0f);
        player.getInventory().setItemInMainHand(null);
    }

    private float getRotationAngle(BlockFace face) {
        return switch (face) {
            case BlockFace.SOUTH -> 180.0f;
            case BlockFace.EAST -> 90.0f;
            case BlockFace.WEST -> -90.0f;
            default -> 0.0f;
        };
    }

    private Vector3 getMoveDirection(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> new Vector3(0.0, 0.0, 1.0);
            case BlockFace.SOUTH -> new Vector3(0.0, 0.0, -1.0);
            case BlockFace.WEST -> new Vector3(1.0, 0.0, 0.0);
            case BlockFace.EAST -> new Vector3(-1.0, 0.0, 0.0);
            default -> new Vector3(0.0, 0.0, 0.0);
        };
    }
}

