/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.items;

import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.json.simple.JSONObject;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.player.LandClaimerProp;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;
import zombieworldproject.zombieracore.remote.database.handlers.DBLocationsHandler;
import zombieworldproject.zombieracore.remote.database.handlers.DBPropHandler;

public class LandClaimer
extends UsableItemBase {
    public LandClaimer() {
        super("Land Claimer", (Integer)2300032, true);
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        return this.thisItem.clone();
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.getRarity()), this.getName()));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Building");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to claim land!");
        meta.setLore(lore);
        meta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (ph == null) {
            ZombiEraCore.playerInfo(player, "Error: Player health data not loaded yet.");
            return;
        }
        if (ph.isUsingItem().booleanValue()) {
            return;
        }
        ph.startUsingItem(20);
        int claimCount = DBPropHandler.landClaimerCountForPlayer(player);
        if (claimCount == -1) {
            ZombiEraCore.playerInfo(player, "Database error. Please try again later.");
            return;
        }
        if (claimCount >= 1) {
            ZombiEraCore.playerInfo(player, "You can only have one land claimed at a time. Remove your existing claim first.");
            return;
        }
        if (LandClaimerProp.isClaimed(player.getLocation()) != null) {
            ZombiEraCore.playerInfo(player, "This land is already claimed!");
            return;
        }
        if (DBLocationsHandler.checkIfLocationWithinLocationWhiteListRadius(player.getLocation())) {
            ZombiEraCore.playerInfo(player, "You cannot claim land here \u2014 restricted area.");
            return;
        }
        PropData prop = ZombiEraCore.getPropManager().placeProp(player, 4, "land_claimer");
        if (prop == null) {
            ZombiEraCore.playerInfo(player, "Failed to place land claimer. Try again later.");
            return;
        }
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("player", player.getUniqueId().toString());
        prop.setPropMetaData("database", new JSONObject(metaData));
        ZombiEraCore.getPropManager().savePropMetaData(prop);
        player.getInventory().setItemInMainHand(null);
        ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.GREEN) + "Land successfully claimed!");
    }
}

