/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.items;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class LandmineItem
extends UsableItemBase
implements ItemBase {
    public LandmineItem() {
        super("Landmine", (Integer)6780104, true);
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        return this.thisItem.clone();
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.MOJANG_BANNER_PATTERN);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.getRarity()), this.getName()));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Placeable");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right click to place a landmine on the ground.");
        meta.setLore(lore);
        meta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        PropData prop = ZombiEraCore.getPropManager().placeProp(player, 4, "player_landmine");
        if (prop == null) {
            ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "Failed to place landmine. Try again later.");
            return;
        }
        player.getInventory().setItemInMainHand(null);
        ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.GREEN) + "Landmine armed and ready!");
    }
}

