/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.props.items;

import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONObject;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsableItemBase;
import zombieworldproject.zombieracore.managers.item.bases.usable.UsingItemSession;
import zombieworldproject.zombieracore.managers.item.builtIn.building.BuildHammer;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.player.LandClaimerProp;
import zombieworldproject.zombieracore.misc.utils.ItemUtils;

public class PlayerStorage
extends UsableItemBase {
    public PlayerStorage() {
        super("Player Storage", (Integer)2300031, true);
    }

    @Override
    public ItemStack getItem() {
        if (this.thisItem == null) {
            this.thisItem = this.createItem();
        }
        return this.thisItem.clone();
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(Material.CREEPER_BANNER_PATTERN);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.format("%s%s", ZombiEraCore.getRarityDropManager().getColor(this.getRarity()), this.getName()));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        List<String> lore = ItemUtils.getItemLore();
        lore.add(String.valueOf(ChatColor.BLUE) + "Building");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Usage:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Right-click to place!");
        lore.add(String.valueOf(ChatColor.YELLOW) + "It must be within your land claim.");
        lore.add(String.valueOf(ChatColor.YELLOW) + "You can pick this up by left-clicking with a Build Hammer.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Notes:");
        lore.add(String.valueOf(ChatColor.YELLOW) + "You need a Build Hammer to place this!");
        meta.setLore(lore);
        meta.setCustomModelData(this.getNBTTag());
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public void playerItemUseByEvent(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (ph == null) {
            ZombiEraCore.playerInfo(player, "Error: player data not found.");
            return;
        }
        if (ph.isUsingItem().booleanValue()) {
            return;
        }
        ph.startUsingItem(20);
        final PropData claimData = LandClaimerProp.isClaimed(player.getLocation());
        if (claimData == null) {
            ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "You can only place this within your land claim.");
            return;
        }
        JSONObject claimMeta = (JSONObject)claimData.getPropMetaData("database");
        if (claimMeta == null) {
            ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "Error: claim metadata missing. Try again later.");
            return;
        }
        String claimOwnerUUID = (String)claimMeta.get((Object)"player");
        if (claimOwnerUUID == null) {
            ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "Error: invalid claim data. Try again later.");
            return;
        }
        if (!player.getUniqueId().toString().equals(claimOwnerUUID)) {
            ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "You can only place this inside your own land claim.");
            return;
        }
        if (!BuildHammer.hasPlayerBuildHammer(player)) {
            ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "You need a Build Hammer to place this!");
            return;
        }
        final UsingItemSession itemSession = new UsingItemSession(player, 120, this.getNBTTag(), 2);
        ZombiEraCore.getSoundManager().playSound(player.getLocation(), "hammering");
        new BukkitRunnable(){

            public void run() {
                itemSession.tick();
                if (!itemSession.isDone().booleanValue()) {
                    return;
                }
                ZombiEraCore.getSoundManager().stopSoundAtPlayer(player, "hammering");
                if (itemSession.isInterrupted().booleanValue()) {
                    this.cancel();
                    return;
                }
                if (claimData.isRemoved()) {
                    ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "You no longer have a land claim!");
                    this.cancel();
                    return;
                }
                PropData storage = ZombiEraCore.getPropManager().placeProp(player, 4, "player_storage");
                if (storage == null) {
                    ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.RED) + "Failed to place storage. Try again later.");
                    this.cancel();
                    return;
                }
                HashMap<String, String> metaMap = new HashMap<String, String>();
                metaMap.put("player", player.getUniqueId().toString());
                Inventory inventory = Bukkit.createInventory(null, (int)54);
                metaMap.put("storage", (String)ItemUtils.serializeInventory(inventory));
                storage.setPropMetaData("database", new JSONObject(metaMap));
                ZombiEraCore.getPropManager().savePropMetaData(storage);
                player.getInventory().setItemInMainHand(null);
                ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.GREEN) + "Storage placed successfully!");
                this.cancel();
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 1L);
    }
}

