/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.recipes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;

public class CustomNBTRecipe {
    private final List<Integer> items = new ArrayList<Integer>();
    final Integer resultItemNbtId;
    final String recipeName;
    final Boolean blueprint;

    public CustomNBTRecipe(Integer resultItemNbtId, String recipeName, Boolean blueprint) {
        this.resultItemNbtId = resultItemNbtId;
        this.recipeName = recipeName;
        this.blueprint = blueprint;
    }

    public boolean playerHasRecipe(Player player) {
        if (!this.blueprint.booleanValue()) {
            return true;
        }
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        return ph != null && ph.doesKnowBlueprint("bp_" + this.recipeName);
    }

    public boolean isRecipe(Inventory inventory) {
        Map<Integer, Integer> recipeItemCounts = this.countItems(this.items);
        HashMap<Integer, Integer> inventoryItemCounts = new HashMap<Integer, Integer>();
        for (ItemStack stack : inventory.getContents()) {
            if (stack == null || stack.getType() == Material.AIR || stack.getItemMeta() == null || !stack.getItemMeta().hasCustomModelData()) continue;
            int nbtId = stack.getItemMeta().getCustomModelData();
            inventoryItemCounts.put(nbtId, inventoryItemCounts.getOrDefault(nbtId, 0) + 1);
        }
        if (inventoryItemCounts.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : recipeItemCounts.entrySet()) {
            int id = (Integer)entry.getKey();
            int requiredCount = (Integer)entry.getValue();
            int availableCount = inventoryItemCounts.getOrDefault(id, 0);
            if (availableCount >= requiredCount) continue;
            return false;
        }
        return true;
    }

    public void addNbtId(Integer nbtId) {
        if (nbtId != null) {
            this.items.add(nbtId);
        }
    }

    public List<Integer> getItemIds() {
        return new ArrayList<Integer>(this.items);
    }

    private Map<Integer, Integer> countItems(List<Integer> ids) {
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        for (Integer id : ids) {
            if (id == null) continue;
            counts.put(id, counts.getOrDefault(id, 0) + 1);
        }
        return counts;
    }
}

