/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.recipes;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.recipes.CustomNBTRecipe;
import zombieworldproject.zombieracore.managers.recipes.RecipeTypes;

public class ZERecipeManager {
    private final List<ShapedRecipe> shapedRecipeList = new ArrayList<ShapedRecipe>();
    private final List<CustomNBTRecipe> customNBTRecipesList = new ArrayList<CustomNBTRecipe>();

    public void clear() {
        this.shapedRecipeList.clear();
        this.customNBTRecipesList.clear();
    }

    public void addRecipe(ShapedRecipe recipe) {
        this.shapedRecipeList.add(recipe);
    }

    public void onPlayerJoinAddRecipes(Player player) {
        player.getDiscoveredRecipes().forEach(arg_0 -> ((Player)player).undiscoverRecipe(arg_0));
        this.shapedRecipeList.forEach(recipe -> player.discoverRecipe(recipe.getKey()));
    }

    public ItemStack checkRecipe(PrepareItemCraftEvent event) {
        CraftingInventory inventory = event.getInventory();
        Player player = (Player)event.getView().getPlayer();
        for (CustomNBTRecipe customRecipe : this.customNBTRecipesList) {
            if (!customRecipe.isRecipe((Inventory)inventory) || !customRecipe.playerHasRecipe(player)) continue;
            return ZombiEraCore.getItemManager().getItemBase(customRecipe.resultItemNbtId).getItem();
        }
        return null;
    }

    public void addCustomRecipe(List<ItemStack> itemStackList, ItemStack resultItemStack, String recipeName, boolean blueprint) {
        if (itemStackList.isEmpty()) {
            return;
        }
        Integer resultItemNbtId = resultItemStack.getItemMeta().getCustomModelData();
        CustomNBTRecipe customRecipe = new CustomNBTRecipe(resultItemNbtId, recipeName, blueprint);
        for (ItemStack stack : itemStackList) {
            if (stack.getItemMeta() == null || !stack.getItemMeta().hasCustomModelData()) continue;
            customRecipe.addNbtId(stack.getItemMeta().getCustomModelData());
        }
        this.customNBTRecipesList.add(customRecipe);
    }

    public void loadRecipes() {
        File configFile = new File(ZombiEraCore.instance.getDataFolder(), "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        ConfigurationSection recipesSection = config.getConfigurationSection("recipes");
        if (recipesSection == null) {
            ZombiEraCore.debugInfo("No recipes found in config.yml");
            return;
        }
        for (String recipeName : recipesSection.getKeys(false)) {
            try {
                ConfigurationSection bpSection;
                ConfigurationSection recipeSection = recipesSection.getConfigurationSection(recipeName);
                if (recipeSection == null) continue;
                String resultItemKey = recipeSection.getString("resultItem");
                if (resultItemKey == null) {
                    ZombiEraCore.debugInfo("Skipping recipe " + recipeName + ": no result item defined.");
                    continue;
                }
                String row1 = recipeSection.getString("row1", "None");
                String row2 = recipeSection.getString("row2", "None");
                String row3 = recipeSection.getString("row3", "None");
                boolean addToBook = recipeSection.getBoolean("book", false);
                String typeStr = recipeSection.getString("type", "NORMAL");
                RecipeTypes recipeType = RecipeTypes.valueOf(typeStr.toUpperCase(Locale.ROOT));
                NamespacedKey key = new NamespacedKey("zombieworld", recipeName);
                ItemStack resultItemStack = ZombiEraCore.getItemManager().getItemBase(resultItemKey).getItem();
                ShapedRecipe shapedRecipe = new ShapedRecipe(key, resultItemStack);
                ArrayList<String> validRows = new ArrayList<String>();
                if (!row1.equalsIgnoreCase("None")) {
                    validRows.add(row1);
                }
                if (!row2.equalsIgnoreCase("None")) {
                    validRows.add(row2);
                }
                if (!row3.equalsIgnoreCase("None")) {
                    validRows.add(row3);
                }
                if (validRows.isEmpty()) {
                    ZombiEraCore.debugInfo("Invalid recipe shape for: " + recipeName);
                    continue;
                }
                shapedRecipe.shape(validRows.toArray(new String[0]));
                HashMap<Character, String> ingredientKeys = new HashMap<Character, String>();
                HashMap<Character, Integer> ingredientCount = new HashMap<Character, Integer>();
                this.countIngredients(row1, ingredientKeys, ingredientCount, recipeSection, recipeName);
                this.countIngredients(row2, ingredientKeys, ingredientCount, recipeSection, recipeName);
                this.countIngredients(row3, ingredientKeys, ingredientCount, recipeSection, recipeName);
                ArrayList<ItemStack> customItemsForNBT = new ArrayList<ItemStack>();
                for (Map.Entry entry : ingredientKeys.entrySet()) {
                    char symbol = ((Character)entry.getKey()).charValue();
                    String value = (String)entry.getValue();
                    if (value == null || value.isBlank() || symbol == ' ') continue;
                    try {
                        if (value.startsWith("material.")) {
                            String matName = value.split("\\.")[1].toUpperCase(Locale.ROOT);
                            shapedRecipe.setIngredient(symbol, Material.valueOf((String)matName));
                            continue;
                        }
                        ItemStack item = ZombiEraCore.getItemManager().getItemBase(value).getItem();
                        if (recipeType == RecipeTypes.CUSTOM) {
                            int count = ingredientCount.getOrDefault(Character.valueOf(symbol), 1);
                            for (int i = 0; i < count; ++i) {
                                customItemsForNBT.add(item);
                            }
                        }
                        shapedRecipe.setIngredient(symbol, item.getType());
                    }
                    catch (Exception e) {
                        ZombiEraCore.debugInfo("Failed to set ingredient for symbol '" + symbol + "' in recipe " + recipeName + ": " + e.getMessage());
                    }
                }
                boolean isBlueprint = false;
                if (recipeSection.isSet("blueprint") && (bpSection = recipeSection.getConfigurationSection("blueprint")) != null && bpSection.getBoolean("create", false)) {
                    isBlueprint = true;
                    String bpName = bpSection.getString("name", "Unnamed Blueprint");
                    ZombiEraCore.getItemManager().addBlueprint(recipeName, bpName, row1, row2, row3, ingredientKeys);
                    ZombiEraCore.debugInfo("Blueprint registered: bp_" + recipeName);
                }
                if (addToBook) {
                    this.addRecipe(shapedRecipe);
                }
                Bukkit.addRecipe((Recipe)shapedRecipe);
                if (recipeType == RecipeTypes.CUSTOM) {
                    this.addCustomRecipe(customItemsForNBT, resultItemStack, recipeName, isBlueprint);
                }
                ZombiEraCore.debugInfo("Loaded recipe: " + recipeName);
            }
            catch (Exception ex) {
                ZombiEraCore.debugInfo("Error loading recipe '" + recipeName + "': " + ex.getMessage());
            }
        }
    }

    private void countIngredients(String row, Map<Character, String> ingredientKeys, Map<Character, Integer> ingredientCount, ConfigurationSection recipeSection, String recipeName) {
        if (row == null || row.equalsIgnoreCase("None")) {
            return;
        }
        for (char c : row.toCharArray()) {
            if (c == ' ') continue;
            if (!ingredientKeys.containsKey(Character.valueOf(c))) {
                ingredientKeys.put(Character.valueOf(c), recipeSection.getString(String.valueOf(c)));
            }
            ingredientCount.put(Character.valueOf(c), ingredientCount.getOrDefault(Character.valueOf(c), 0) + 1);
        }
    }
}

