/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.spawners;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.managers.spawners.LocalSpawnerConfigItem;
import zombieworldproject.zombieracore.misc.utils.EntityUtils;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;
import zombieworldproject.zombieracore.remote.database.views.LocalSpawnerView;

public class LocalSpawnerItem {
    private final LocalSpawnerView view;
    private final Location location;
    LocalSpawnerConfigItem config;
    private BukkitRunnable task;
    private List<LivingEntity> entities = new ArrayList<LivingEntity>();
    private Integer bonusSecs = 0;
    private Integer ticks = 0;

    public LocalSpawnerItem(LocalSpawnerView view, LocalSpawnerConfigItem config) {
        this.view = view;
        this.config = config;
        World w = Bukkit.getWorld((String)view.getWorld());
        this.location = new Location(w, view.getX(), view.getY(), view.getZ());
    }

    public void entityDeathEvent(EntityDeathEvent event) {
        ZombiEraCore.debugInfo("Spawner entity death event");
        ZombiEraCore.getLocalSpawnerManager().unregisterEntity(event.getEntity());
        this.bonusSecs = this.bonusSecs + this.config.safeBonusSecs;
    }

    public void tick() {
        if (this.task != null) {
            return;
        }
        if (this.config.spawnAllAtLoad.booleanValue()) {
            this.spawn(this.config.maxEntities);
        }
        this.task = new BukkitRunnable(){

            public void run() {
                World w = Bukkit.getWorld((String)LocalSpawnerItem.this.view.getWorld());
                LocalSpawnerItem.this.location.setWorld(w);
                LocalSpawnerItem.this.ticks = LocalSpawnerItem.this.ticks + LocalSpawnerItem.this.config.delayTicks;
                if (!LocalSpawnerItem.this.location.isChunkLoaded()) {
                    ZombiEraCore.debugInfo("Unloaded");
                    this.cancel();
                    LocalSpawnerItem.this.task = null;
                    return;
                }
                if (LocalSpawnerItem.this.ticks >= 20) {
                    LocalSpawnerItem.this.bonusSecs = LocalSpawnerItem.this.bonusSecs - 1 < 0 ? Integer.valueOf(0) : Integer.valueOf(LocalSpawnerItem.this.bonusSecs - 1);
                    LocalSpawnerItem.this.ticks = 0;
                }
                if (LocalSpawnerItem.this.bonusSecs == 0) {
                    LocalSpawnerItem.this.spawn(1);
                }
                ZombiEraCore.debugInfo(String.format("Bonus secs %s, size: %s", LocalSpawnerItem.this.bonusSecs, LocalSpawnerItem.this.entities.size()));
            }
        };
        this.task.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, (long)this.config.delayTicks.intValue());
    }

    public void spawn(int count) {
        ArrayList toRemove = new ArrayList();
        this.entities.forEach(entity -> {
            if (entity.isDead() || !entity.isValid()) {
                toRemove.add(entity);
            }
        });
        toRemove.forEach(entity -> this.entities.remove(entity));
        for (int i = 0; i < count && this.entities.size() < this.config.maxEntities; ++i) {
            EntityBase entityBase = this.config.getRandomEntityBase();
            if (entityBase == null) {
                ZombiEraCore.debugInfo("Entity base is null!");
                continue;
            }
            Location tempLoc = this.location.clone();
            World world = Bukkit.getWorld((String)this.view.getWorld());
            tempLoc.setWorld(world);
            tempLoc.add(this.config.radius * (double)MiscUtils.randomNegativePositiveInt().intValue() * MiscUtils.globalRandom.nextDouble(), 0.0, this.config.radius * (double)MiscUtils.randomNegativePositiveInt().intValue() * MiscUtils.globalRandom.nextDouble());
            LivingEntity entity2 = ZombiEraCore.getEntityManager().tryRandomSpawn(entityBase, tempLoc, world);
            if (entity2 == null) continue;
            entity2.setAI(false);
            entity2.setInvulnerable(true);
            entity2.teleport(entity2.getLocation().add(0.0, -1.0, 0.0));
            EntityUtils.emergeEntity(entity2.getLocation(), entity2, 1.0);
            ZombiEraCore.getLocalSpawnerManager().registerEntity(this, entity2);
            this.entities.add(entity2);
            ZombiEraCore.debugInfo(String.format("Spawner (%s) spawned entity: %s at %s, %s, %s", this.config.name, entityBase.dirName, this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ()));
        }
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public LocalSpawnerView getView() {
        return this.view;
    }
}

