/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.spawners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.spawners.LocalSpawnerConfigItem;
import zombieworldproject.zombieracore.managers.spawners.LocalSpawnerItem;
import zombieworldproject.zombieracore.misc.utils.ChunkUtils;
import zombieworldproject.zombieracore.remote.database.handlers.DBLocalSpawnerHandler;
import zombieworldproject.zombieracore.remote.database.views.LocalSpawnerView;

public class LocalSpawnerManager {
    File configFile;
    private final Map<String, LocalSpawnerConfigItem> spawnerTypes = new HashMap<String, LocalSpawnerConfigItem>();
    private final Map<String, LocalSpawnerItem> spawnerItems;
    private final Map<String, Map<String, LocalSpawnerItem>> itemsByChunk;
    private final Map<Integer, LocalSpawnerItem> entityToSpawner = new HashMap<Integer, LocalSpawnerItem>();

    public void registerEntity(LocalSpawnerItem spawner, LivingEntity entity) {
        this.entityToSpawner.put(entity.getEntityId(), spawner);
        ZombiEraCore.debugInfo("Spawner entity registered");
    }

    public void unregisterEntity(LivingEntity entity) {
        this.entityToSpawner.remove(entity.getEntityId());
        ZombiEraCore.debugInfo("Spawner entity unregistered");
    }

    public LocalSpawnerItem getSpawnerForEntity(LivingEntity entity) {
        return this.entityToSpawner.get(entity.getEntityId());
    }

    public List<String> getAllSpawnerTypes() {
        return new ArrayList<String>(this.spawnerTypes.keySet());
    }

    public LocalSpawnerManager() {
        this.spawnerItems = new HashMap<String, LocalSpawnerItem>();
        this.itemsByChunk = new HashMap<String, Map<String, LocalSpawnerItem>>();
        this.reloadConfig();
        this.reloadDatabase();
    }

    public void reloadConfig() {
        block8: {
            block7: {
                this.configFile = new File(ZombiEraCore.instance.getDataFolder(), "spawners.yml");
                this.spawnerTypes.clear();
                if (!this.configFile.exists()) break block7;
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
                ConfigurationSection configSection = config.getConfigurationSection("spawners");
                if (configSection == null) break block8;
                for (String spawnerName : configSection.getKeys(false)) {
                    Integer delayTicks = config.getInt(String.format("spawners.%s.delay-ticks", spawnerName));
                    Integer maxEntities = config.getInt(String.format("spawners.%s.max-entities", spawnerName));
                    Double radius = config.getDouble(String.format("spawners.%s.radius", spawnerName));
                    Boolean spawnAllAtLoad = config.getBoolean(String.format("spawners.%s.spawn-all-at-load", spawnerName));
                    Integer safeBonusSecs = config.getInt(String.format("spawners.%s.safe-bonus-secs", spawnerName));
                    LocalSpawnerConfigItem configItem = new LocalSpawnerConfigItem(spawnerName, delayTicks, maxEntities, radius, spawnAllAtLoad, safeBonusSecs);
                    ConfigurationSection entitiesSection = config.getConfigurationSection(String.format("spawners.%s.entities", spawnerName));
                    if (entitiesSection != null) {
                        for (String entityName : entitiesSection.getKeys(false)) {
                            Integer weight = config.getInt(String.format("spawners.%s.entities.%s.weight", spawnerName, entityName));
                            configItem.addEntity(entityName, weight);
                        }
                    }
                    ZombiEraCore.debugInfo(String.format("Loaded spawner: %s", spawnerName));
                    this.spawnerTypes.put(spawnerName, configItem);
                }
                break block8;
            }
            try {
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
            try {
                config.save(this.configFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void run() {
        new BukkitRunnable(){

            public void run() {
                List<LocalSpawnerItem> activeSpawners = LocalSpawnerManager.this.getActiveSpawners();
                activeSpawners.forEach(spawner -> spawner.tick());
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 10L);
    }

    public void reloadDatabase() {
        HashMap<String, LocalSpawnerView> views = DBLocalSpawnerHandler.getAllSpawnersMap();
        for (LocalSpawnerView view : views.values()) {
            LocalSpawnerItem item = new LocalSpawnerItem(view, this.spawnerTypes.get(view.getSpawnerType()));
            this.spawnerItems.put(view.getName(), item);
            String chunkKey = ChunkUtils.chunkKey(view.getWorld(), view.getX(), view.getZ());
            this.itemsByChunk.computeIfAbsent(chunkKey, k -> new HashMap()).put(view.getName(), item);
        }
    }

    public boolean addSpawner(String name, Location loc, String spawnerType) {
        LocalSpawnerItem oldItem = this.spawnerItems.get(name);
        if (oldItem != null) {
            oldItem.stop();
            String oldKey = ChunkUtils.chunkKey(oldItem.getView().getWorld(), oldItem.getView().getX(), oldItem.getView().getZ());
            Map<String, LocalSpawnerItem> oldChunkMap = this.itemsByChunk.get(oldKey);
            if (oldChunkMap != null) {
                oldChunkMap.remove(name);
                if (oldChunkMap.isEmpty()) {
                    this.itemsByChunk.remove(oldKey);
                }
            }
            this.spawnerItems.remove(name);
        }
        LocalSpawnerView view = new LocalSpawnerView(name, loc.getX(), loc.getY(), loc.getZ(), loc.getWorld().getName(), spawnerType);
        LocalSpawnerConfigItem configItem = this.spawnerTypes.get(spawnerType);
        if (configItem == null) {
            ZombiEraCore.debugInfo("Unknown spawner type: " + spawnerType);
            return false;
        }
        DBLocalSpawnerHandler.upsertSpawner(view);
        LocalSpawnerItem newItem = new LocalSpawnerItem(view, configItem);
        this.spawnerItems.put(name, newItem);
        String newKey = ChunkUtils.chunkKey(loc);
        this.itemsByChunk.computeIfAbsent(newKey, k -> new HashMap()).put(name, newItem);
        return true;
    }

    public boolean deleteSpawner(String name) {
        LocalSpawnerItem item = this.spawnerItems.remove(name);
        if (item == null) {
            return false;
        }
        item.stop();
        DBLocalSpawnerHandler.deleteSpawner(item.getView());
        String chunkKey = ChunkUtils.chunkKey(item.getView().getWorld(), item.getView().getX(), item.getView().getZ());
        Map<String, LocalSpawnerItem> chunkMap = this.itemsByChunk.get(chunkKey);
        if (chunkMap != null) {
            chunkMap.remove(name);
            if (chunkMap.isEmpty()) {
                this.itemsByChunk.remove(chunkKey);
            }
        }
        return true;
    }

    public List<LocalSpawnerItem> getActiveSpawners() {
        ArrayList<LocalSpawnerItem> active = new ArrayList<LocalSpawnerItem>();
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                String key = world.getName() + ":" + chunk.getX() + "_" + chunk.getZ();
                Map<String, LocalSpawnerItem> map = this.itemsByChunk.get(key);
                if (map == null) continue;
                active.addAll(map.values());
            }
        }
        return active;
    }
}

