/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.zones;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.entity.EntityBase;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ConfigZone {
    private final List<EntityBase> spawnEntities;
    private final String dirname;

    public ConfigZone(String dirName) {
        this.dirname = dirName;
        this.spawnEntities = new ArrayList<EntityBase>();
        File configFile = new File(ZombiEraCore.instance.getDataFolder(), "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        ConfigurationSection entitySection = config.getConfigurationSection("zones." + dirName + ".entities");
        if (entitySection == null) {
            return;
        }
        for (String entityName : entitySection.getKeys(false)) {
            int spawnWeight = config.getInt("zones." + dirName + ".entities." + entityName + ".spawnWeight", 1);
            if (spawnWeight <= 0) continue;
            EntityBase entityBase = ZombiEraCore.getEntityManager().getEntityBaseByName(entityName);
            if (entityBase == null) {
                ZombiEraCore.debugInfo("ConfigZone: Unknown entity '" + entityName + "' in zone '" + dirName + "'");
                continue;
            }
            for (int i = 0; i < spawnWeight; ++i) {
                this.spawnEntities.add(entityBase);
            }
        }
    }

    public String getDirname() {
        return this.dirname;
    }

    public EntityBase getRandomSpawnEntityBase() {
        if (this.spawnEntities.isEmpty()) {
            return null;
        }
        int randomIndex = MiscUtils.globalRandom.nextInt(this.spawnEntities.size());
        return this.spawnEntities.get(randomIndex);
    }
}

