/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.zones;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.ZEBossBarManager;
import zombieworldproject.zombieracore.managers.zones.ConfigZone;
import zombieworldproject.zombieracore.managers.zones.ZoneBase;
import zombieworldproject.zombieracore.managers.zones.ZoneTypes;
import zombieworldproject.zombieracore.managers.zones.types.LivableZone;
import zombieworldproject.zombieracore.managers.zones.types.RadiationZone;
import zombieworldproject.zombieracore.managers.zones.types.SafeZone;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class ZEZoneManager {
    private static final String ZONES_ROOT_PATH = "zones";
    private final Map<ZoneTypes, String> zoneTypesScoreboardStrings = ZEZoneManager.createZoneTypesScoreboardStrings();
    private final HashMap<String, ZoneBase> zones;
    private File configFile;
    private YamlConfiguration config;
    private final Map<String, ConfigZone> configZones = new HashMap<String, ConfigZone>();

    public ZEZoneManager() {
        this.zones = new HashMap();
        this.initConfigFile();
        this.loadConfigIntoMemory();
        this.run();
    }

    private static Map<ZoneTypes, String> createZoneTypesScoreboardStrings() {
        EnumMap<ZoneTypes, CallSite> map = new EnumMap<ZoneTypes, CallSite>(ZoneTypes.class);
        map.put(ZoneTypes.RADIATION, (CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "\u2623" + String.valueOf(ChatColor.GREEN) + " RADIATION " + String.valueOf(ChatColor.YELLOW) + "\u2623")));
        map.put(ZoneTypes.SAFE, (CallSite)((Object)(String.valueOf(ChatColor.GREEN) + "SAFE")));
        map.put(ZoneTypes.NONE, (CallSite)((Object)(String.valueOf(ChatColor.RED) + "DANGEROUS")));
        map.put(ZoneTypes.LIVABLE, (CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "LIVABLE")));
        return Collections.unmodifiableMap(map);
    }

    private void initConfigFile() {
        if (this.configFile == null) {
            this.configFile = new File(ZombiEraCore.instance.getDataFolder(), "zones.yml");
        }
    }

    private void ensureConfigFileExists() {
        this.initConfigFile();
        if (this.configFile.exists()) {
            return;
        }
        File parent = this.configFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            boolean created = this.configFile.createNewFile();
            if (!created) {
                ZombiEraCore.instance.getLogger().log(Level.WARNING, "zones.yml file could not be created or already exists.");
            }
        }
        catch (IOException e) {
            ZombiEraCore.instance.getLogger().log(Level.SEVERE, "Failed to create zones.yml file.", e);
        }
    }

    private void loadConfigIntoMemory() {
        this.ensureConfigFileExists();
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    private YamlConfiguration getConfig() {
        if (this.config == null) {
            this.loadConfigIntoMemory();
        }
        return this.config;
    }

    private void saveConfig() {
        if (this.config == null) {
            return;
        }
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            ZombiEraCore.instance.getLogger().log(Level.SEVERE, "Failed to save zones.yml configuration.", e);
        }
    }

    private void writeBaseZoneConfig(String zoneDirname, ZoneBase zone) {
        Location loc = zone.getPoint1();
        this.getConfig().set(String.format("%s.%s.x", ZONES_ROOT_PATH, zoneDirname), (Object)loc.getX());
        this.getConfig().set(String.format("%s.%s.y", ZONES_ROOT_PATH, zoneDirname), (Object)loc.getY());
        this.getConfig().set(String.format("%s.%s.z", ZONES_ROOT_PATH, zoneDirname), (Object)loc.getZ());
        this.getConfig().set(String.format("%s.%s.world", ZONES_ROOT_PATH, zoneDirname), (Object)Objects.requireNonNull(loc.getWorld()).getName());
        this.getConfig().set(String.format("%s.%s.boxData", ZONES_ROOT_PATH, zoneDirname), (Object)zone.getBoxData());
        this.getConfig().set(String.format("%s.%s.type", ZONES_ROOT_PATH, zoneDirname), (Object)zone.getZoneType().toString());
    }

    public List<ZoneTypes> getLocationZones(Location location) {
        ArrayList<ZoneTypes> zoneTypesList = new ArrayList<ZoneTypes>();
        this.zones.forEach((dirName, zone) -> {
            if (zone.isInZone(location) && !zoneTypesList.contains((Object)zone.getZoneType())) {
                zoneTypesList.add(zone.getZoneType());
            }
        });
        return zoneTypesList;
    }

    public Location getRandomLivableZoneLocation() {
        ArrayList livableZones = new ArrayList();
        this.zones.forEach((dirName, zone) -> {
            if (zone instanceof LivableZone) {
                LivableZone livableZone = (LivableZone)zone;
                livableZones.add(livableZone);
            }
        });
        if (!livableZones.isEmpty()) {
            LivableZone randomLivableZone = (LivableZone)livableZones.get(MiscUtils.globalRandom.nextInt(0, livableZones.size()));
            Location zoneLocation = randomLivableZone.getPoint1();
            Double zoneRadius = randomLivableZone.getRadius();
            if (zoneRadius == null) {
                Location zoneLocation2 = randomLivableZone.getPoint2().clone();
                return this.getRandomLocationBetween(zoneLocation, zoneLocation2);
            }
            return zoneLocation.add((double)MiscUtils.globalRandom.nextFloat() * zoneRadius * (double)MiscUtils.randomNegativePositiveInt().intValue(), 0.0, (double)MiscUtils.globalRandom.nextFloat() * zoneRadius * (double)MiscUtils.randomNegativePositiveInt().intValue());
        }
        return null;
    }

    public Location getRandomLocationBetween(Location zoneLocation, Location zoneLocation2) {
        Random random = new Random();
        double minX = Math.min(zoneLocation.getX(), zoneLocation2.getX());
        double minY = Math.min(zoneLocation.getY(), zoneLocation2.getY());
        double minZ = Math.min(zoneLocation.getZ(), zoneLocation2.getZ());
        double maxX = Math.max(zoneLocation.getX(), zoneLocation2.getX());
        double maxY = Math.max(zoneLocation.getY(), zoneLocation2.getY());
        double maxZ = Math.max(zoneLocation.getZ(), zoneLocation2.getZ());
        double randomX = minX + (maxX - minX) * random.nextDouble();
        double randomY = minY + (maxY - minY) * random.nextDouble();
        double randomZ = minZ + (maxZ - minZ) * random.nextDouble();
        return new Location(zoneLocation.getWorld(), randomX, randomY, randomZ);
    }

    public boolean checkForZoneAtLocation(ZoneTypes type, Location location) {
        return this.getLocationZones(location).contains((Object)type);
    }

    public HashMap<String, ZoneBase> getAllZones() {
        return this.zones;
    }

    public List<String> getDirNames() {
        return new ArrayList<String>(this.zones.keySet());
    }

    public List<String> getConfigZoneDirNames() {
        return new ArrayList<String>(this.configZones.keySet());
    }

    public String getZoneTypeScoreboardString(ZoneTypes type) {
        return this.zoneTypesScoreboardStrings.get((Object)type);
    }

    private void run() {
        final ZEBossBarManager bossBarManager = ZombiEraCore.getBossBarManager();
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    ZEZoneManager.this.playerCheckForZones(player);
                    bossBarManager.showPlayerCoords(player);
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 5L);
    }

    public void reloadZones() {
        this.zones.forEach((dirName, zone) -> zone.stopBehaviour());
        this.zones.clear();
        this.configZones.clear();
        this.loadConfigIntoMemory();
        Bukkit.getWorlds().forEach(this::loadZonesFromFile);
        ZombiEraCore.getZombiEraConfigManager().loadConfigZones();
    }

    public void loadZonesFromFile(World world) {
        YamlConfiguration cfg = this.getConfig();
        ConfigurationSection configSection = cfg.getConfigurationSection(ZONES_ROOT_PATH);
        if (configSection == null) {
            return;
        }
        for (String key : configSection.getKeys(false)) {
            String configZoneName;
            String worldName = cfg.getString(String.format("%s.%s.world", ZONES_ROOT_PATH, key));
            if (worldName == null || !worldName.equals(world.getName())) continue;
            double x = cfg.getDouble(String.format("%s.%s.x", ZONES_ROOT_PATH, key));
            double y = cfg.getDouble(String.format("%s.%s.y", ZONES_ROOT_PATH, key));
            double z = cfg.getDouble(String.format("%s.%s.z", ZONES_ROOT_PATH, key));
            Location loc = new Location(world, x, y, z);
            String typeString = cfg.getString(String.format("%s.%s.type", ZONES_ROOT_PATH, key));
            if (typeString == null) continue;
            ZoneTypes type = ZoneTypes.valueOf(typeString);
            String boxData = cfg.getString(String.format("%s.%s.boxData", ZONES_ROOT_PATH, key));
            if (boxData == null) continue;
            String configZonePath = String.format("%s.%s.configZone", ZONES_ROOT_PATH, key);
            boolean hasConfigZone = cfg.isSet(configZonePath);
            String string = configZoneName = hasConfigZone ? cfg.getString(configZonePath) : null;
            if (type.equals((Object)ZoneTypes.RADIATION)) {
                Double hazardLevel = cfg.getDouble(String.format("%s.%s.hazardLevel", ZONES_ROOT_PATH, key));
                if (hasConfigZone && configZoneName != null) {
                    this.addRadiationZone(key, loc, boxData, hazardLevel, configZoneName);
                } else {
                    this.addRadiationZone(key, loc, boxData, hazardLevel);
                }
            } else if (hasConfigZone && configZoneName != null) {
                this.addZone(key, type, loc, boxData, configZoneName);
            } else {
                this.addZone(key, type, loc, boxData);
            }
            ZombiEraCore.debugInfo("Loaded zone with key: " + key);
        }
    }

    public void addConfigZone(String dirName) {
        this.configZones.put(dirName, new ConfigZone(dirName));
    }

    public boolean addZone(String zoneDirname, ZoneTypes zoneType, Location location, String boxData) {
        if (this.zones.containsKey(zoneDirname)) {
            return false;
        }
        if (zoneType == ZoneTypes.SAFE || zoneType == ZoneTypes.LIVABLE) {
            ZoneBase zone = zoneType == ZoneTypes.SAFE ? new SafeZone(location, boxData, null) : new LivableZone(location, boxData, null);
            zone.runBehaviour();
            this.zones.put(zoneDirname, zone);
            this.writeBaseZoneConfig(zoneDirname, zone);
            this.saveConfig();
            return true;
        }
        return false;
    }

    public void addRadiationZone(String zoneDirname, Location location, String boxData, Double hazardLevel) {
        RadiationZone zone = new RadiationZone(location, boxData, hazardLevel, null);
        zone.runBehaviour();
        this.zones.put(zoneDirname, zone);
        this.writeBaseZoneConfig(zoneDirname, zone);
        this.getConfig().set(String.format("%s.%s.hazardLevel", ZONES_ROOT_PATH, zoneDirname), (Object)zone.getHazardLevel());
        this.saveConfig();
    }

    public boolean addZone(String zoneDirname, ZoneTypes zoneType, Location location, String boxData, String configZone) {
        if (this.zones.containsKey(zoneDirname) || !this.configZones.containsKey(configZone)) {
            return false;
        }
        ConfigZone configZone1 = this.configZones.get(configZone);
        if (zoneType == ZoneTypes.SAFE || zoneType == ZoneTypes.LIVABLE) {
            ZoneBase zone = zoneType == ZoneTypes.SAFE ? new SafeZone(location, boxData, configZone1) : new LivableZone(location, boxData, configZone1);
            zone.runBehaviour();
            this.zones.put(zoneDirname, zone);
            this.writeBaseZoneConfig(zoneDirname, zone);
            this.getConfig().set(String.format("%s.%s.configZone", ZONES_ROOT_PATH, zoneDirname), (Object)configZone1.getDirname());
            this.saveConfig();
            return true;
        }
        return false;
    }

    public boolean addRadiationZone(String zoneDirname, Location location, String boxData, Double hazardLevel, String configZone) {
        if (this.zones.containsKey(zoneDirname) || !this.configZones.containsKey(configZone)) {
            return false;
        }
        ConfigZone configZone1 = this.configZones.get(configZone);
        RadiationZone zone = new RadiationZone(location, boxData, hazardLevel, configZone1);
        zone.runBehaviour();
        this.zones.put(zoneDirname, zone);
        this.writeBaseZoneConfig(zoneDirname, zone);
        this.getConfig().set(String.format("%s.%s.configZone", ZONES_ROOT_PATH, zoneDirname), (Object)configZone1.getDirname());
        this.getConfig().set(String.format("%s.%s.hazardLevel", ZONES_ROOT_PATH, zoneDirname), (Object)zone.getHazardLevel());
        this.saveConfig();
        return true;
    }

    public void printOutZonesToPlayer(Player player) {
        this.zones.forEach((dirName, zone) -> {
            Location zoneLocation = zone.getPoint1();
            if (zone.getZoneType().equals((Object)ZoneTypes.RADIATION)) {
                ZombiEraCore.playerInfo(player, String.format("Dirname: %s; Type: %s; Location: x%sy%sz%s; Hazard Level: %s", new Object[]{dirName, zone.getZoneType(), zoneLocation.getBlockX(), zoneLocation.getBlockY(), zoneLocation.getBlockZ(), ((RadiationZone)zone).getHazardLevel()}));
            } else {
                ZombiEraCore.playerInfo(player, String.format("Dirname: %s; Type: %s; Location: x%sy%sz%s", new Object[]{dirName, zone.getZoneType(), zoneLocation.getBlockX(), zoneLocation.getBlockY(), zoneLocation.getBlockZ()}));
            }
        });
    }

    public boolean removeZone(String dirName) {
        if (!this.zones.containsKey(dirName)) {
            return false;
        }
        ZoneBase zone = this.zones.remove(dirName);
        if (zone != null) {
            zone.stopBehaviour();
        }
        this.getConfig().set(String.format("%s.%s", ZONES_ROOT_PATH, dirName), null);
        this.saveConfig();
        return true;
    }

    public void playerCheckForZones(Player player) {
        this.zones.forEach((dirName, zone) -> zone.updatePlayerZone(player));
    }
}

