/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.zones;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.player.ZEScoreBoardManager;
import zombieworldproject.zombieracore.managers.player.states.PlayerHealth;
import zombieworldproject.zombieracore.managers.zones.ConfigZone;
import zombieworldproject.zombieracore.managers.zones.ZoneTypes;

public abstract class ZoneBase {
    protected final List<Player> players = Collections.synchronizedList(new ArrayList());
    protected volatile boolean isRunning = true;
    protected final boolean boxed;
    protected final Location point1;
    protected final Double radius;
    protected final ZoneTypes zoneType;
    protected final ConfigZone configZone;
    protected final Location point2;
    protected final String boxData;
    private static final Map<UUID, BukkitRunnable> dangerTimers = new ConcurrentHashMap<UUID, BukkitRunnable>();

    public ZoneBase(ZoneTypes zoneType, Location location, String boxData, ConfigZone configZone) {
        this.point1 = location.clone();
        this.zoneType = zoneType;
        this.boxData = boxData;
        this.configZone = configZone;
        Location tempPoint2 = null;
        Double tempRadius = null;
        boolean tempBoxed = false;
        if (boxData.contains(",")) {
            tempBoxed = true;
            String[] xyz = boxData.split(",");
            if (xyz.length == 3) {
                tempPoint2 = new Location(location.getWorld(), Double.parseDouble(xyz[0]), Double.parseDouble(xyz[1]), Double.parseDouble(xyz[2]));
            }
        } else {
            tempRadius = Double.parseDouble(boxData);
        }
        this.point2 = tempPoint2;
        this.radius = tempRadius;
        this.boxed = tempBoxed;
    }

    public String getBoxData() {
        return this.boxData;
    }

    public boolean hasConfigZone() {
        return this.configZone != null;
    }

    public ConfigZone getConfigZone() {
        return this.configZone;
    }

    public void stopBehaviour() {
        this.isRunning = false;
    }

    public Double getRadius() {
        return this.radius;
    }

    public Location getPoint1() {
        return this.point1.clone();
    }

    public Location getPoint2() {
        return this.point2;
    }

    public ZoneTypes getZoneType() {
        return this.zoneType;
    }

    public abstract void runBehaviour();

    public abstract void onPlayerEnter(Player var1);

    public abstract void onPlayerLeave(Player var1);

    public void checkPlayerDangerousZone(final Player player) {
        if (player.isDead() || !player.isOnline()) {
            return;
        }
        PlayerHealth health = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (!health.getCurrentZones().isEmpty()) {
            return;
        }
        if (dangerTimers.containsKey(player.getUniqueId())) {
            return;
        }
        player.sendTitle(String.valueOf(ChatColor.GRAY) + " LIVEABLE ZONE ", String.valueOf(ChatColor.WHITE) + "<<" + String.valueOf(ChatColor.RED) + " Leaving, go back or you will die! " + String.valueOf(ChatColor.WHITE) + ">>", 1, 30, 10);
        final int[] countdown = new int[]{10};
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                if (!player.isOnline() || player.isDead()) {
                    this.cancel();
                    dangerTimers.remove(player.getUniqueId());
                    return;
                }
                if (!ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).getCurrentZones().isEmpty()) {
                    ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.AQUA) + "\n-------------------------------------\n" + String.valueOf(ChatColor.AQUA) + "Zone Manager " + String.valueOf(ChatColor.WHITE) + "[" + String.valueOf(ChatColor.GREEN) + "Info" + String.valueOf(ChatColor.WHITE) + "]\nYou are safe again!\n-------------------------------------");
                    this.cancel();
                    dangerTimers.remove(player.getUniqueId());
                    return;
                }
                countdown[0] = countdown[0] - 1;
                if (countdown[0] > 0) {
                    ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.AQUA) + "\n-------------------------------------\n" + String.valueOf(ChatColor.AQUA) + "Zone Manager " + String.valueOf(ChatColor.WHITE) + "[" + String.valueOf(ChatColor.GREEN) + "Info" + String.valueOf(ChatColor.WHITE) + "]\nYou will die in: " + String.valueOf(ChatColor.RED) + countdown[0] + " seconds" + String.valueOf(ChatColor.WHITE) + " if you don't return!\n-------------------------------------");
                } else {
                    ZombiEraCore.playerInfo(player, String.valueOf(ChatColor.AQUA) + "\n-------------------------------------\n" + String.valueOf(ChatColor.AQUA) + "Zone Manager " + String.valueOf(ChatColor.WHITE) + "[" + String.valueOf(ChatColor.RED) + "Warning" + String.valueOf(ChatColor.WHITE) + "]\n" + String.valueOf(ChatColor.RED) + "Dangerous UV rays from a hole in the ozone layer killed you.\n-------------------------------------");
                    player.damage(9999.0);
                    this.cancel();
                    dangerTimers.remove(player.getUniqueId());
                }
            }
        };
        dangerTimers.put(player.getUniqueId(), task);
        task.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 20L);
    }

    public boolean isInZone(Location location) {
        if (!Objects.equals(location.getWorld(), this.point1.getWorld())) {
            return false;
        }
        if (this.boxed && this.point2 != null) {
            double x = location.getX();
            double y = location.getY();
            double z = location.getZ();
            double minX = Math.min(this.point1.getX(), this.point2.getX());
            double minY = Math.min(this.point1.getY(), this.point2.getY());
            double minZ = Math.min(this.point1.getZ(), this.point2.getZ());
            double maxX = Math.max(this.point1.getX(), this.point2.getX());
            double maxY = Math.max(this.point1.getY(), this.point2.getY());
            double maxZ = Math.max(this.point1.getZ(), this.point2.getZ());
            return x >= minX && x <= maxX && y >= minY && y <= maxY && z >= minZ && z <= maxZ;
        }
        return this.radius != null && location.distanceSquared(this.point1) <= this.radius * this.radius;
    }

    public void updatePlayerZone(Player player) {
        boolean inside = this.isInZone(player.getLocation());
        boolean tracked = this.players.contains(player);
        PlayerHealth ph = ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player);
        if (inside && !tracked) {
            this.players.add(player);
            ph.playerEnterZone(this);
            this.onPlayerEnter(player);
            ZEScoreBoardManager.setScoreBoardPlayer(player);
        } else if (!inside && tracked) {
            this.players.remove(player);
            ph.playerLeaveZone(this);
            this.onPlayerLeave(player);
            ZEScoreBoardManager.setScoreBoardPlayer(player);
        }
    }
}

