/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.managers.zones.types;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.item.bases.equitable.ZEEquipmentsManager;
import zombieworldproject.zombieracore.managers.zones.ConfigZone;
import zombieworldproject.zombieracore.managers.zones.ZoneBase;
import zombieworldproject.zombieracore.managers.zones.ZoneTypes;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public class RadiationZone
extends ZoneBase {
    Double hazardLevel;

    public RadiationZone(Location location, String boxData, Double hazardLevel, ConfigZone configZone) {
        super(ZoneTypes.RADIATION, location, boxData, configZone);
        this.hazardLevel = hazardLevel;
    }

    public Double getHazardLevel() {
        return this.hazardLevel;
    }

    @Override
    public void runBehaviour() {
        new BukkitRunnable(){

            public void run() {
                if (!RadiationZone.this.isRunning) {
                    this.cancel();
                    return;
                }
                for (Player player : RadiationZone.this.players) {
                    Double ratio;
                    ZEEquipmentsManager.EquipmentInventory equipmentInventory = ZEEquipmentsManager.playerEquipmentInventories.get(player);
                    if (equipmentInventory == null || !((ratio = Double.valueOf(equipmentInventory.getTotalRadiationProtection() / RadiationZone.this.hazardLevel)) < 1.0)) continue;
                    player.damage(4.0 * (1.0 - ratio));
                    ZombiEraCore.getSoundManager().playSound(player, "radiationhit", 1.0f, 1.0f + MiscUtils.globalRandom.nextFloat() * 0.15f);
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 80L);
    }

    @Override
    public void onPlayerEnter(Player player) {
        ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), String.valueOf(ChatColor.YELLOW) + "\u2623 " + String.valueOf(ChatColor.GREEN) + "Hazard Level: " + String.valueOf(ChatColor.WHITE) + this.getHazardLevel() + String.valueOf(ChatColor.YELLOW) + " \u2623", 10);
        ZombiEraCore.playerInfo(player, "\n-------------------------------------\n" + String.valueOf(ChatColor.AQUA) + "Zone Manager" + String.format("%s: [%sInfo%s]", ChatColor.WHITE, ChatColor.GREEN, ChatColor.WHITE) + "\n" + String.valueOf(ChatColor.YELLOW) + "\u2623" + String.valueOf(ChatColor.GREEN) + " RADIATION ZONE " + String.valueOf(ChatColor.YELLOW) + "\u2623\n" + String.valueOf(ChatColor.WHITE) + "<<" + String.valueOf(ChatColor.AQUA) + " Entering " + String.valueOf(ChatColor.WHITE) + ">>\n-------------------------------------");
    }

    @Override
    public void onPlayerLeave(final Player player) {
        ZombiEraCore.playerInfo(player, "\n-------------------------------------\n" + String.valueOf(ChatColor.AQUA) + "Zone Manager" + String.format("%s: [%sInfo%s]", ChatColor.WHITE, ChatColor.GREEN, ChatColor.WHITE) + "\n" + String.valueOf(ChatColor.YELLOW) + "\u2623" + String.valueOf(ChatColor.GREEN) + " RADIATION ZONE " + String.valueOf(ChatColor.YELLOW) + "\u2623\n" + String.valueOf(ChatColor.WHITE) + "<<" + String.valueOf(ChatColor.RED) + " Leaving " + String.valueOf(ChatColor.WHITE) + ">>\n-------------------------------------");
        new BukkitRunnable(){

            public void run() {
                RadiationZone.this.checkPlayerDangerousZone(player);
            }
        }.runTaskLater((Plugin)ZombiEraCore.instance, 60L);
    }
}

