/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.misc.utils;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import zombieworldproject.zombieracore.ZombiEraCore;

public final class BlockUtils {
    public static boolean hasSolidBlockUnderneath(Location location) {
        World world = location.getWorld();
        Block blockUnderneath = world.getBlockAt(location.clone().subtract(0.0, 1.0, 0.0));
        return blockUnderneath.getType().isSolid();
    }

    public static void detectAndLaunchBlocks(Location center, int radius, long flyingDuration) {
        World world = center.getWorld();
        HashSet<Material> detectedMaterials = new HashSet<Material>();
        for (int x = center.getBlockX() - radius; x <= center.getBlockX() + radius; ++x) {
            for (int y = center.getBlockY() - radius; y <= center.getBlockY() + radius; ++y) {
                for (int z = center.getBlockZ() - radius; z <= center.getBlockZ() + radius; ++z) {
                    Block block = world.getBlockAt(x, y, z);
                    Material blockType = block.getType();
                    if (blockType == Material.AIR || detectedMaterials.contains(blockType)) continue;
                    detectedMaterials.add(blockType);
                    if (detectedMaterials.size() < 3) continue;
                    BlockUtils.launchBlocks(center, detectedMaterials, flyingDuration);
                    return;
                }
            }
        }
    }

    public static void launchBlocks(Location center, Set<Material> blockTypes, long flyingDuration) {
        for (Material blockType : blockTypes) {
            Location blockLocation = center.clone().add(0.5, 0.5, 0.5);
            FallingBlock fallingBlock = blockLocation.getWorld().spawnFallingBlock(blockLocation, blockType.createBlockData());
            fallingBlock.setDropItem(false);
            BlockUtils.launchFlyingBlock(fallingBlock, flyingDuration);
        }
    }

    public static void launchFlyingBlock(final FallingBlock fallingBlock, final long flyingDuration) {
        Vector direction = new Vector(Math.random() - 0.5, 1.0, Math.random() - 0.5).normalize();
        fallingBlock.setVelocity(direction.multiply(1.6));
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if ((long)this.ticks >= flyingDuration) {
                    fallingBlock.remove();
                    this.cancel();
                    return;
                }
                this.ticks += 5;
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 5L);
    }
}

