/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.misc.utils;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.misc.utils.MiscUtils;

public final class EntityUtils {
    public static void emergeEntity(final Location startLoc, final LivingEntity entity, final Double deltaInput) {
        new BukkitRunnable(){
            private final int maxFrames = 50;
            private int frameCount = 0;

            public void run() {
                if (this.frameCount < 50) {
                    double deltaY = deltaInput / 50.0;
                    entity.teleport(entity.getLocation().clone().add(0.0, deltaY, 0.0));
                    EntityUtils.spawnDustParticles(startLoc.clone().add(0.0, 2.2, 0.0));
                    if (MiscUtils.generateChance(10)) {
                        entity.getLocation().getWorld().playSound(entity.getLocation(), Sound.BLOCK_ROOTED_DIRT_BREAK, 1.0f, 1.0f);
                    }
                    ++this.frameCount;
                } else {
                    entity.setAI(true);
                    entity.setInvulnerable(false);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ZombiEraCore.instance, 0L, 2L);
    }

    private static void spawnDustParticles(Location center) {
        World world = center.getWorld();
        Particle particle = Particle.REDSTONE;
        Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)156, (int)100, (int)23), 1.0f);
        world.spawnParticle(particle, center, MiscUtils.generateBetweenNumbers(8, 15).intValue(), 0.25, 0.25, 0.25, 0.25, (Object)dustOptions);
    }
}

