/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.misc.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.ZombiEraSettings;
import zombieworldproject.zombieracore.managers.item.bases.ItemBase;
import zombieworldproject.zombieracore.managers.item.bases.equitable.items.EquitableItemBase;
import zombieworldproject.zombieracore.managers.item.bases.gun.ArmedGunItemBase;
import zombieworldproject.zombieracore.managers.item.bases.melee.MeleeItemBase;
import zombieworldproject.zombieracore.managers.item.builtIn.misc.GasCanister;

public class ItemUtils {
    public static JSONObject serializeInventory(Inventory inventory) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"size", (Object)inventory.getSize());
        JSONArray slotsArray = new JSONArray();
        jsonObject.put((Object)"slots", (Object)slotsArray);
        for (ItemStack itemStack : inventory.getContents()) {
            if (itemStack == null) continue;
            JSONObject itemObject = new JSONObject();
            itemObject.put((Object)"material", (Object)itemStack.getType().toString());
            itemObject.put((Object)"nbt", (Object)itemStack.getItemMeta().getCustomModelData());
            itemObject.put((Object)"name", (Object)itemStack.getItemMeta().getDisplayName());
            itemObject.put((Object)"amount", (Object)itemStack.getAmount());
            List lore = itemStack.getItemMeta().getLore();
            if (lore != null) {
                JSONArray loreArray = new JSONArray();
                loreArray.addAll((Collection)lore);
                itemObject.put((Object)"lore", (Object)loreArray);
            }
            slotsArray.add((Object)itemObject);
        }
        return jsonObject;
    }

    public static Inventory deserializeInventory(String jsonString) {
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)parser.parse(jsonString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        int size = ((Long)jsonObject.get((Object)"size")).intValue();
        JSONArray slotsArray = (JSONArray)jsonObject.get((Object)"slots");
        Inventory inventory = Bukkit.createInventory(null, (int)size);
        for (Object slotObject : slotsArray) {
            JSONObject slot = (JSONObject)slotObject;
            int nbt = ((Long)slot.get((Object)"nbt")).intValue();
            ItemBase itemBase = ZombiEraCore.getItemManager().getItemBase(nbt);
            ItemStack itemStack = itemBase.getItem().clone();
            ItemMeta meta = itemStack.getItemMeta();
            if (slot.containsKey((Object)"name")) {
                meta.setDisplayName((String)slot.get((Object)"name"));
            }
            if (slot.containsKey((Object)"lore")) {
                JSONArray loreArray = (JSONArray)slot.get((Object)"lore");
                ArrayList<String> lore = new ArrayList<String>();
                for (Object loreObject : loreArray) {
                    lore.add((String)loreObject);
                }
                meta.setLore(lore);
            }
            if (slot.containsKey((Object)"nbt")) {
                meta.setCustomModelData(Integer.valueOf(((Long)slot.get((Object)"nbt")).intValue()));
            }
            if (slot.containsKey((Object)"amount")) {
                itemStack.setAmount(((Long)slot.get((Object)"amount")).intValue());
            }
            itemStack.setItemMeta(meta);
            inventory.addItem(new ItemStack[]{itemStack});
        }
        return inventory;
    }

    public static Integer getDurability(ItemStack item) {
        List lore = item.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            String loreLine = (String)lore.get(i);
            if (!loreLine.contains("Durability")) continue;
            String durability = loreLine.substring(loreLine.indexOf("<") + 1, loreLine.indexOf(">"));
            String[] durabilities = durability.split("/");
            return Integer.valueOf(durabilities[0]);
        }
        return null;
    }

    public static void setDurability(ItemStack item, Integer durability) {
        ItemMeta meta = item.getItemMeta();
        int id = meta.getCustomModelData();
        ItemBase base = ZombiEraCore.getItemManager().getItemBase(id);
        Integer maxDurability = 0;
        if (base instanceof MeleeItemBase) {
            MeleeItemBase meleeItemBase = (MeleeItemBase)base;
            maxDurability = meleeItemBase.maxDurability;
        } else if (base instanceof ArmedGunItemBase) {
            ArmedGunItemBase armedGunItemBase = (ArmedGunItemBase)base;
            maxDurability = armedGunItemBase.maxDurability;
        } else if (base instanceof EquitableItemBase) {
            EquitableItemBase equitableItemBase = (EquitableItemBase)base;
            maxDurability = equitableItemBase.maxDurability;
        }
        List lore = item.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            String loreLine = (String)lore.get(i);
            if (!loreLine.contains("Durability")) continue;
            lore.set(i, ItemUtils.generatedurability(durability, maxDurability));
            meta.setLore(lore);
            item.setItemMeta(meta);
            break;
        }
    }

    public static void addCapacity(ItemStack item, Integer capacityAdd) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            if (!line.contains("Capacity")) continue;
            int capNow = ItemUtils.getCapacity(line);
            int capNext = capNow + capacityAdd;
            lore.set(i, line.replace(String.format("(%s)", capNow), String.format("(%s)", capNext)));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public static Integer getCapacity(String line) {
        return Integer.parseInt(line.substring(line.indexOf("(") + 1, line.indexOf(")")));
    }

    public static Integer getCapacity(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            if (!line.contains("Capacity")) continue;
            return Integer.parseInt(line.substring(line.indexOf("(") + 1, line.indexOf(")")));
        }
        return -1;
    }

    public static String getValueFromLore(ItemStack item, String value, String afterLine) {
        value = value.toLowerCase();
        afterLine = afterLine.toLowerCase();
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        boolean afterLineFound = false;
        for (String line : lore) {
            if (line.toLowerCase().contains(afterLine)) {
                afterLineFound = true;
            }
            if (!line.toLowerCase().contains(value) || !afterLineFound) continue;
            return line.toLowerCase().substring(line.indexOf("<") + 1, line.indexOf(">"));
        }
        return null;
    }

    public static void setCapacity(ItemStack item, Integer capacity) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            if (!line.contains("Capacity")) continue;
            int capNow = ItemUtils.getCapacity(line);
            lore.set(i, line.replace(String.format("(%s)", capNow), String.format("(%s)", capacity)));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public static List<String> getItemLore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.format("%s%s", ChatColor.GREEN, ZombiEraSettings.ITEM_NAME_IDENTIFIER));
        return lore;
    }

    public static void refillGasItem(final Player player, ItemStack gasItem, final Integer maxAmmoCapacity) {
        if (ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).isUsingItem().booleanValue()) {
            return;
        }
        final Integer nbtIdStart = gasItem.getItemMeta().getCustomModelData();
        ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).stopUsingItem();
        final PlayerInventory playerInv = player.getInventory();
        GasCanister gasCanister = (GasCanister)ZombiEraCore.getItemManager().usableItems.get("gascanister");
        final ItemStack itemCanister = gasCanister.getItem();
        final ArrayList<Integer> canisters = new ArrayList<Integer>();
        for (int i = 0; i <= 35; ++i) {
            Integer capacity;
            ItemStack item = playerInv.getItem(i);
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || item.getItemMeta().getCustomModelData() != itemCanister.getItemMeta().getCustomModelData() || (capacity = ItemUtils.getCapacity(item)) <= 0) continue;
            canisters.add(i);
        }
        if (canisters.size() == 0) {
            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "No gasoline!", 5);
            ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).stopUsingItem();
        } else {
            final int[] count = new int[]{0};
            new BukkitRunnable(){

                public void run() {
                    ItemStack handItem = playerInv.getItemInMainHand();
                    if (handItem.hasItemMeta() && handItem.getItemMeta().hasCustomModelData() && handItem.getItemMeta().getCustomModelData() == nbtIdStart.intValue()) {
                        int filled = 0;
                        for (int i = 0; i < canisters.size(); ++i) {
                            ItemStack can = playerInv.getItem(((Integer)canisters.get(i)).intValue());
                            if (can == null || !can.hasItemMeta() || !can.getItemMeta().hasCustomModelData() || can.getItemMeta().getCustomModelData() != itemCanister.getItemMeta().getCustomModelData()) continue;
                            int capacityNow = ItemUtils.getCapacity(can);
                            int capacityItemToBeFilled = ItemUtils.getCapacity(handItem);
                            if (capacityNow > 0 && capacityItemToBeFilled < maxAmmoCapacity) {
                                ItemUtils.addCapacity(can, -1);
                                ++filled;
                                count[0] = count[0] + 1;
                                if (count[0] % 5 == 0) {
                                    ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Filling..." + ".".repeat(count[0] % 2), 5);
                                    player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 5, 1));
                                }
                                ItemUtils.addCapacity(handItem, 1);
                                continue;
                            }
                            if (capacityItemToBeFilled == maxAmmoCapacity) {
                                ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Filled!", 5);
                                ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).stopUsingItem();
                                this.cancel();
                                return;
                            }
                            filled = 0;
                        }
                        if (filled == 0) {
                            ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "No gasoline!", 5);
                            ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).stopUsingItem();
                            this.cancel();
                        }
                    } else {
                        ZombiEraCore.ZEPlayerManagers.getSpecialMessagesManager().addActionBarMessage(player.getName(), "Filling interrupted!", 5);
                        ZombiEraCore.ZEPlayerManagers.getHealthManager().getPlayerHealth(player).stopUsingItem();
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)ZombiEraCore.instance, 1L, 1L);
        }
    }

    public static String generatedurability(Integer durabilityNow, Integer durabilityMax) {
        return String.format("%sDurability: <%s/%s>", ChatColor.WHITE, durabilityNow, durabilityMax);
    }
}

