/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.misc.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class MiscUtils {
    public static Random globalRandom = new Random();

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static List<List<String>> splitAndSortList(List<String> originalList, int batchSize) {
        Collections.sort(originalList);
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        int totalItems = originalList.size();
        int startIndex = 0;
        while (startIndex < totalItems) {
            int endIndex = Math.min(startIndex + batchSize, totalItems);
            ArrayList<String> batch = new ArrayList<String>(originalList.subList(startIndex, endIndex));
            resultList.add(batch);
            startIndex = endIndex;
        }
        return resultList;
    }

    public static <K, V> Map.Entry<K, V> getRandomEntry(HashMap<K, V> map) {
        if (map.isEmpty()) {
            return null;
        }
        Object[] keyArray = map.keySet().toArray();
        Random random = new Random();
        int randomIndex = random.nextInt(keyArray.length);
        Object randomKey = keyArray[randomIndex];
        V randomValue = map.get(randomKey);
        return new AbstractMap.SimpleEntry<Object, V>(randomKey, randomValue);
    }

    public static <K, V> Map.Entry<K, V> getRandomEntry(Map<K, V> map) {
        if (map.isEmpty()) {
            return null;
        }
        Object[] keyArray = map.keySet().toArray();
        Random random = new Random();
        int randomIndex = random.nextInt(keyArray.length);
        Object randomKey = keyArray[randomIndex];
        V randomValue = map.get(randomKey);
        return new AbstractMap.SimpleEntry<Object, V>(randomKey, randomValue);
    }

    public static <T> T getRandomEntry(List<T> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("List cannot be null or empty");
        }
        Random rand = new Random();
        int randomIndex = rand.nextInt(list.size());
        return list.get(randomIndex);
    }

    public static boolean generateChance(int chance) {
        Random rand = new Random();
        return rand.nextFloat() * 100.0f >= (float)(100 - chance);
    }

    public static Integer generateBetweenNumbers(Integer lower, Integer upper) {
        return globalRandom.nextInt(upper - lower + 1) + lower;
    }

    public static boolean generateChange(float chance) {
        Random rand = new Random();
        return rand.nextFloat() <= chance / 100.0f;
    }

    public static boolean generateChange(double chance) {
        Random rand = new Random();
        return (double)rand.nextFloat() <= chance / 100.0;
    }

    public static Integer randomNegativePositiveInt() {
        Random rand = new Random();
        if (rand.nextBoolean()) {
            return 1;
        }
        return -1;
    }

    public static <K, V> HashMap<V, K> reverse(Map<K, V> map) {
        HashMap<V, K> rev = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            rev.put(entry.getValue(), entry.getKey());
        }
        return rev;
    }
}

