/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.remote.api;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import org.json.simple.JSONObject;
import zombieworldproject.zombieracore.remote.api.ApiKeyValidator;
import zombieworldproject.zombieracore.remote.api.ApiResponse;

public class ApiClient {
    private final String baseUrl;
    private final String apiKey;
    private final ApiKeyValidator validator;
    private final HttpClient client;

    public ApiClient(String baseUrl, String verifyUrl, String apiKey) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.apiKey = apiKey;
        this.validator = new ApiKeyValidator(verifyUrl);
        this.client = HttpClient.newHttpClient();
    }

    public boolean validateKey() {
        ApiResponse res = this.validator.validate(this.apiKey);
        if (!res.isValid()) {
            System.out.println("\u274c API key invalid or disabled: " + res.getReason());
            return false;
        }
        System.out.println("\u2705 API key valid: " + res.getReason());
        return true;
    }

    public ApiResponse get(String endpoint) {
        if (!this.validateKey()) {
            return new ApiResponse(false, false, 403, "", "Invalid API key");
        }
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.baseUrl + endpoint)).header("Accept", "application/json").header("X-API-Key", this.apiKey).GET().build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            boolean success = response.statusCode() >= 200 && response.statusCode() < 300;
            return new ApiResponse(success, true, response.statusCode(), response.body(), "GET request complete");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ApiResponse(false, true, 0, "", "Exception: " + e.getMessage());
        }
    }

    public ApiResponse post(String endpoint, JSONObject jsonBody) {
        if (!this.validateKey()) {
            return new ApiResponse(false, false, 403, "", "Invalid API key");
        }
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.baseUrl + endpoint)).header("Content-Type", "application/json").header("X-API-Key", this.apiKey).POST(HttpRequest.BodyPublishers.ofString(jsonBody.toJSONString(), StandardCharsets.UTF_8)).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            boolean success = response.statusCode() >= 200 && response.statusCode() < 300;
            return new ApiResponse(success, true, response.statusCode(), response.body(), "POST request complete");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ApiResponse(false, true, 0, "", "Exception: " + e.getMessage());
        }
    }
}

