/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.remote.api;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import zombieworldproject.zombieracore.remote.api.ApiResponse;

public class ApiKeyValidator {
    private final String verifyUrl;
    private final HttpClient client;

    public ApiKeyValidator(String verifyUrl) {
        this.verifyUrl = verifyUrl;
        this.client = HttpClient.newHttpClient();
    }

    public ApiResponse validate(String apiKey) {
        try {
            JSONObject body = new JSONObject();
            body.put((Object)"api_key", (Object)apiKey);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.verifyUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body.toJSONString(), StandardCharsets.UTF_8)).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(response.body());
            boolean success = (Boolean)json.getOrDefault((Object)"success", (Object)false);
            boolean valid = (Boolean)json.getOrDefault((Object)"valid", (Object)false);
            String reason = (String)json.getOrDefault((Object)"reason", (Object)"Unknown");
            return new ApiResponse(success, valid, response.statusCode(), response.body(), reason);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ApiResponse(false, false, 0, "", "Exception: " + e.getMessage());
        }
    }
}

