/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.remote.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.remote.database.handlers.DBAuctionHandler;
import zombieworldproject.zombieracore.remote.database.handlers.DBBlocksHandler;
import zombieworldproject.zombieracore.remote.database.handlers.DBLocalSpawnerHandler;
import zombieworldproject.zombieracore.remote.database.handlers.DBLocationsHandler;
import zombieworldproject.zombieracore.remote.database.handlers.DBPropHandler;
import zombieworldproject.zombieracore.remote.database.views.PropDataView;

public class DBManager {
    private static final int timeOutMax = 10;
    private static Connection connection;
    private static int timeOutTimer;

    private static File getDatabaseFile() {
        File dbFile = new File(ZombiEraCore.instance.getDataFolder(), "zombiera_core.db");
        if (!dbFile.getParentFile().exists()) {
            dbFile.getParentFile().mkdirs();
        }
        return dbFile;
    }

    public static Connection getConnection() {
        if (connection == null) {
            try {
                Class.forName("org.sqlite.JDBC");
                File dbFile = DBManager.getDatabaseFile();
                connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
                connection.setAutoCommit(true);
                DBManager.onConnect();
                timeOutTimer = 0;
                ZombiEraCore.debugInfo("SQLite database connected successfully.");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return connection;
    }

    public static boolean checkTimeout() {
        if (timeOutTimer >= 10) {
            Bukkit.getPluginManager().disablePlugin((Plugin)ZombiEraCore.instance);
            return true;
        }
        return false;
    }

    public static void executeCommand(String command) {
        DBManager.getConnection();
        if (DBManager.checkTimeout()) {
            return;
        }
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate(command);
            timeOutTimer = 0;
        }
        catch (SQLException e) {
            System.out.println("[DBManager] SQL Error: " + e.getMessage());
            connection = null;
            ++timeOutTimer;
            e.printStackTrace();
            DBManager.executeCommand(command);
        }
    }

    public static int executeCommandAndGetGeneratedKey(String sql) {
        DBManager.getConnection();
        if (DBManager.checkTimeout()) {
            return -1;
        }
        int generatedKey = -1;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1);){
            stmt.executeUpdate();
            try (ResultSet rs = stmt.getGeneratedKeys();){
                if (rs.next()) {
                    generatedKey = rs.getInt(1);
                }
            }
            timeOutTimer = 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            ++timeOutTimer;
            connection = null;
            DBManager.executeCommandAndGetGeneratedKey(sql);
        }
        return generatedKey;
    }

    public static ResultSet executeQuery(String query) {
        DBManager.getConnection();
        if (DBManager.checkTimeout()) {
            return null;
        }
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            timeOutTimer = 0;
            return rs;
        }
        catch (SQLException e) {
            e.printStackTrace();
            ++timeOutTimer;
            connection = null;
            DBManager.executeQuery(query);
            return null;
        }
    }

    public static void clearTable(String tableName) {
        try {
            DBManager.executeCommand("DELETE FROM " + tableName + ";");
            System.out.println("Table '" + tableName + "' cleared successfully.");
        }
        catch (Exception e) {
            System.out.println("Error clearing table: " + e.getMessage());
        }
    }

    public static void createDatabase() {
        ZombiEraCore.debugInfo("Ensuring SQLite database file exists...");
        DBManager.getDatabaseFile();
    }

    public static void onConnect() {
        DBManager.createDatabase();
        DBLocationsHandler.createTables();
        DBLocationsHandler.loadAllLocations();
        DBPropHandler.createTables();
        DBBlocksHandler.createTables();
        DBAuctionHandler.createTables();
        DBLocalSpawnerHandler.createTables();
    }

    public static void closeConnection() {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
                ZombiEraCore.debugInfo("SQLite connection closed.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new DBManager();
        Connection conn = DBManager.getConnection();
        List<PropDataView> propDataViews = DBPropHandler.loadAllProps();
        for (PropDataView propDataView : propDataViews) {
            System.out.println(propDataView.getId());
            System.out.println(propDataView.getMetadata());
        }
        System.out.println("Done");
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        timeOutTimer = 0;
    }
}

