/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.remote.database.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.remote.database.DBManager;
import zombieworldproject.zombieracore.remote.database.handlers.AuctionViewType;
import zombieworldproject.zombieracore.remote.database.views.AuctionItemView;

public class DBAuctionHandler {
    private static final int pageSize = 52;

    public static void createTables() {
        DBManager.executeCommand("CREATE TABLE IF NOT EXISTS `auctions` (\n  `id` INT AUTO_INCREMENT PRIMARY KEY,\n  `item_nbt` INT NOT NULL,\n  `item_material` VARCHAR(255) NOT NULL,\n  `item_name` VARCHAR(255) NOT NULL,\n  `item_lore` LONGTEXT DEFAULT NULL,\n  `item_amount` INT NOT NULL,\n  `item_unit_price` DOUBLE NOT NULL,\n  `timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n  `seller_uuid` VARCHAR(255) NOT NULL,\n  `buyer_uuid` VARCHAR(255) DEFAULT NULL\n)");
    }

    public static List<AuctionItemView> viewActiveAuctions(int page, AuctionViewType type) {
        String query = String.format("SELECT * FROM auctions WHERE buyer_uuid IS NULL ORDER BY timestamp %s LIMIT 52 OFFSET " + page * 52, type == AuctionViewType.TIME_DESCEND ? "DESC" : "ASC");
        ArrayList<AuctionItemView> auctionItemViews = new ArrayList<AuctionItemView>();
        try {
            ResultSet rs = DBManager.getConnection().createStatement().executeQuery(query);
            while (rs.next()) {
                auctionItemViews.add(new AuctionItemView(rs.getInt("id"), rs.getInt("item_nbt"), rs.getString("item_material"), rs.getString("item_name"), rs.getString("item_lore"), rs.getInt("item_amount"), rs.getInt("item_unit_price"), rs.getTimestamp("timestamp"), rs.getString("seller_uuid"), rs.getString("buyer_uuid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return auctionItemViews;
    }

    public static List<AuctionItemView> viewCustomActiveAuctions(int page, AuctionViewType type, String sellerUUID) {
        String query = String.format("SELECT * FROM auctions WHERE buyer_uuid IS NULL AND seller_uuid = '%s' ORDER BY timestamp %s LIMIT 52 OFFSET " + page * 52, sellerUUID, type == AuctionViewType.TIME_DESCEND ? "DESC" : "ASC");
        ArrayList<AuctionItemView> auctionItemViews = new ArrayList<AuctionItemView>();
        try {
            ResultSet rs = DBManager.getConnection().createStatement().executeQuery(query);
            while (rs.next()) {
                auctionItemViews.add(new AuctionItemView(rs.getInt("id"), rs.getInt("item_nbt"), rs.getString("item_material"), rs.getString("item_name"), rs.getString("item_lore"), rs.getInt("item_amount"), rs.getInt("item_unit_price"), rs.getTimestamp("timestamp"), rs.getString("seller_uuid"), rs.getString("buyer_uuid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return auctionItemViews;
    }

    public static List<AuctionItemView> viewCustomSoldAuctions(int page, AuctionViewType type, String sellerUUID) {
        String query = String.format("SELECT * FROM auctions WHERE buyer_uuid IS NOT NULL AND seller_uuid = '%s' ORDER BY timestamp %s LIMIT 52 OFFSET " + page * 52, sellerUUID, type == AuctionViewType.TIME_DESCEND ? "DESC" : "ASC");
        ArrayList<AuctionItemView> auctionItemViews = new ArrayList<AuctionItemView>();
        try {
            ResultSet rs = DBManager.getConnection().createStatement().executeQuery(query);
            while (rs.next()) {
                auctionItemViews.add(new AuctionItemView(rs.getInt("id"), rs.getInt("item_nbt"), rs.getString("item_material"), rs.getString("item_name"), rs.getString("item_lore"), rs.getInt("item_amount"), rs.getInt("item_unit_price"), rs.getTimestamp("timestamp"), rs.getString("seller_uuid"), rs.getString("buyer_uuid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return auctionItemViews;
    }

    public static void addSale(int itemNBT, String itemMaterial, String itemName, String itemLore, int itemAmount, int itemUnitPrice, String sellerUUID) {
        int id = DBManager.executeCommandAndGetGeneratedKey("INSERT INTO auctions (item_nbt, item_material, item_name, item_lore, item_amount, item_unit_price, seller_uuid) VALUES (" + itemNBT + ", '" + itemMaterial + "', '" + itemName + "', '" + itemLore + "', " + itemAmount + ", " + itemUnitPrice + ", '" + sellerUUID + "')");
        if (id == -1) {
            ZombiEraCore.debugInfo("Failed to add sale to database.");
        }
    }

    public static void addPurchase(int id, String buyerUUID) {
        DBManager.executeCommand("UPDATE auctions SET buyer_uuid = '" + buyerUUID + "' WHERE id = " + id);
    }

    public static void removeSale(int id) {
        DBManager.executeCommand("DELETE FROM auctions WHERE id = " + id);
    }

    public static void removeAllSales() {
        DBManager.executeCommand("DELETE FROM auctions");
    }
}

