/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.remote.database.handlers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.remote.database.DBManager;
import zombieworldproject.zombieracore.remote.database.views.LocalSpawnerView;

public class DBLocalSpawnerHandler {
    public static void createTables() {
        DBManager.executeCommand("CREATE TABLE IF NOT EXISTS spawners (name VARCHAR(50) NOT NULL, world VARCHAR(50) NOT NULL, x DOUBLE NOT NULL, y DOUBLE NOT NULL, z DOUBLE NOT NULL, spawnerType VARCHAR(50) NOT NULL, PRIMARY KEY (world, name))");
    }

    public static void upsertSpawner(LocalSpawnerView spawner) {
        String sql = "INSERT INTO spawners (name, world, x, y, z, spawnerType) VALUES (?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE x = VALUES(x), y = VALUES(y), z = VALUES(z), spawnerType = VALUES(spawnerType)";
        try (PreparedStatement ps = DBManager.getConnection().prepareStatement(sql);){
            ps.setString(1, spawner.getName());
            ps.setString(2, spawner.getWorld());
            ps.setDouble(3, spawner.getX());
            ps.setDouble(4, spawner.getY());
            ps.setDouble(5, spawner.getZ());
            ps.setString(6, spawner.getSpawnerType());
            ps.executeUpdate();
            ZombiEraCore.debugInfo("Upserted spawner '" + spawner.getName() + "'");
        }
        catch (SQLException e) {
            ZombiEraCore.debugInfo("Error upserting spawner: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void deleteSpawner(LocalSpawnerView spawner) {
        String cmd = String.format("DELETE FROM spawners WHERE name = '%s' AND world = '%s';", spawner.getName(), spawner.getWorld());
        DBManager.executeCommand(cmd);
        ZombiEraCore.debugInfo("Deleted spawner '" + spawner.getName() + "' in world '" + spawner.getWorld() + "'");
    }

    public static void deleteAllByType(String spawnerType) {
        String cmd = "DELETE FROM spawners WHERE spawnerType = '" + spawnerType + "';";
        DBManager.executeCommand(cmd);
        ZombiEraCore.debugInfo("Deleted all spawners of type: " + spawnerType);
    }

    public static void deleteAllByWorld(String world) {
        String cmd = "DELETE FROM spawners WHERE world = '" + world + "';";
        DBManager.executeCommand(cmd);
        ZombiEraCore.debugInfo("Deleted all spawners in world: " + world);
    }

    public static LocalSpawnerView getSpawner(String name, String world) {
        try {
            String q = String.format("SELECT * FROM spawners WHERE name = '%s' AND world = '%s';", name, world);
            ResultSet rs = DBManager.getConnection().createStatement().executeQuery(q);
            if (rs.next()) {
                return new LocalSpawnerView(rs.getString("name"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getString("world"), rs.getString("spawnerType"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<LocalSpawnerView> getAllSpawnersByType(String spawnerType) {
        ArrayList<LocalSpawnerView> list = new ArrayList<LocalSpawnerView>();
        try {
            String q = "SELECT * FROM spawners WHERE spawnerType = '" + spawnerType + "';";
            ResultSet rs = DBManager.getConnection().createStatement().executeQuery(q);
            while (rs.next()) {
                list.add(new LocalSpawnerView(rs.getString("name"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getString("world"), rs.getString("spawnerType")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<LocalSpawnerView> getAllSpawnersByWorld(String world) {
        ArrayList<LocalSpawnerView> list = new ArrayList<LocalSpawnerView>();
        try {
            String q = "SELECT * FROM spawners WHERE world = '" + world + "';";
            ResultSet rs = DBManager.getConnection().createStatement().executeQuery(q);
            while (rs.next()) {
                list.add(new LocalSpawnerView(rs.getString("name"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getString("world"), rs.getString("spawnerType")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static HashMap<String, LocalSpawnerView> getAllSpawnersMap() {
        HashMap<String, LocalSpawnerView> map = new HashMap<String, LocalSpawnerView>();
        try {
            ResultSet rs = DBManager.getConnection().createStatement().executeQuery("SELECT * FROM spawners;");
            while (rs.next()) {
                String name = rs.getString("name");
                double x = rs.getDouble("x");
                double y = rs.getDouble("y");
                double z = rs.getDouble("z");
                String world = rs.getString("world");
                String spawnerType = rs.getString("spawnerType");
                LocalSpawnerView view = new LocalSpawnerView(name, x, y, z, world, spawnerType);
                map.put(name, view);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }
}

