/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.remote.database.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import zombieworldproject.zombieracore.remote.database.DBManager;
import zombieworldproject.zombieracore.remote.database.views.LocationView;

public class DBLocationsHandler {
    public static HashMap<String, LocationView> locationViews = new HashMap();
    public static List<LocationView> whiteListLocations = new ArrayList<LocationView>();

    public static void createTables() {
        DBManager.executeCommand("CREATE TABLE IF NOT EXISTS locations (id INT AUTO_INCREMENT PRIMARY KEY,name VARCHAR(255),type VARCHAR(20),x DOUBLE,y DOUBLE,z DOUBLE,world VARCHAR(20),data VARCHAR(255) DEFAULT NULL)");
    }

    public static boolean checkIfLocationWithinLocationWhiteListRadius(Location location) {
        for (LocationView locationView : whiteListLocations) {
            Location locationViewLocation;
            if (!locationView.getWorld().equals(location.getWorld().getName()) || !(location.distance(locationViewLocation = new Location(location.getWorld(), locationView.getX(), locationView.getY(), locationView.getZ())) <= Double.parseDouble(locationView.getData()) + 30.0)) continue;
            return true;
        }
        return false;
    }

    public static List<LocationView> getWhiteListLocationsFromLocationViews() {
        ArrayList<LocationView> whiteListLocations = new ArrayList<LocationView>();
        for (LocationView locationView : locationViews.values()) {
            if (!locationView.getType().equals("WHITELIST")) continue;
            whiteListLocations.add(locationView);
        }
        return whiteListLocations;
    }

    public static void loadAllLocations() {
        locationViews.clear();
        try {
            ResultSet rs = DBManager.getConnection().createStatement().executeQuery("SELECT * FROM locations");
            while (rs.next()) {
                locationViews.put(rs.getString("name"), new LocationView(rs.getInt("id"), rs.getString("name"), rs.getString("type"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getString("world"), rs.getString("data")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        whiteListLocations = DBLocationsHandler.getWhiteListLocationsFromLocationViews();
    }

    public static void addLocation(String name, String type, double x, double y, double z, String world, String data) {
        int id = DBManager.executeCommandAndGetGeneratedKey("INSERT INTO locations (name, type, x, y, z, world, data) VALUES ('" + name + "', '" + type + "', " + x + ", " + y + ", " + z + ", '" + world + "', '" + data + "')");
        locationViews.put(name, new LocationView(id, name, type, x, y, z, world, data));
        if (type.equals("WHITELIST")) {
            whiteListLocations.add(new LocationView(id, name, type, x, y, z, world, data));
        }
    }

    public static void addWhiteListLocation(String name, double x, double y, double z, String world, String data) {
        DBLocationsHandler.addLocation(name, "WHITELIST", x, y, z, world, data);
    }
}

