/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.remote.database.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.json.simple.JSONObject;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.managers.props.PropHandler;
import zombieworldproject.zombieracore.managers.props.data.PropData;
import zombieworldproject.zombieracore.managers.props.handlers.player.LandClaimerProp;
import zombieworldproject.zombieracore.managers.props.handlers.player.StorageProp;
import zombieworldproject.zombieracore.remote.database.DBManager;
import zombieworldproject.zombieracore.remote.database.views.PropDataView;

public class DBPropHandler {
    public static void createTables() {
        DBPropHandler.createPropsTable();
    }

    private static void createPropsTable() {
        DBManager.executeCommand("CREATE TABLE IF NOT EXISTS props (id INT AUTO_INCREMENT PRIMARY KEY,prop VARCHAR(255),x DOUBLE,y DOUBLE,z DOUBLE,yaw DOUBLE,pitch DOUBLE,xD DOUBLE,yD DOUBLE,zD DOUBLE,world VARCHAR(255),metadata LONGTEXT DEFAULT NULL)");
    }

    public static boolean updatePropMetaData(PropDataView propDataView) {
        ZombiEraCore.debugInfo(propDataView.getMetadata().toJSONString());
        try {
            String query = "UPDATE props SET metadata = '%s' WHERE id = %s";
            String formattedQuery = String.format(query, propDataView.getMetadata().toJSONString(), propDataView.getId());
            DBManager.executeCommand(formattedQuery);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int saveProp(PropDataView propDataView) {
        try {
            String query = "INSERT INTO props (prop, x, y, z, yaw, pitch, xD, yD, zD, world, metadata) VALUES ('%s', %s, %s, %s, %s, %s, %s, %s, %s, '%s', '%s')";
            String metadata = null;
            if (propDataView.getMetadata() != null) {
                metadata = propDataView.getMetadata().toJSONString();
            }
            String formattedQuery = String.format(query, propDataView.getProp(), propDataView.getX(), propDataView.getY(), propDataView.getZ(), propDataView.getYaw(), propDataView.getPitch(), propDataView.getxD(), propDataView.getyD(), propDataView.getzD(), propDataView.getWorld(), metadata);
            return DBManager.executeCommandAndGetGeneratedKey(formattedQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean deleteProp(PropDataView propDataView) {
        try {
            String query = "DELETE FROM props WHERE id = %s";
            String formattedQuery = String.format(query, propDataView.getId());
            DBManager.executeCommand(formattedQuery);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int landClaimerCountForPlayer(Player player) {
        try {
            String query = "SELECT COUNT(*) FROM props WHERE prop = 'land_claimer' AND metadata LIKE '%%\"player\":\"%s\"%%'";
            String formattedQuery = String.format(query, player.getUniqueId());
            ResultSet resultSet = DBManager.executeQuery(formattedQuery);
            resultSet.next();
            return resultSet.getInt(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void deleteAllBaseBuildingPropsForPlayer(Player player) {
        ArrayList<PropData> toRemove = new ArrayList<PropData>();
        for (PropData pd : ZombiEraCore.getPropManager().propDataMap.values()) {
            String id;
            JSONObject object;
            PropHandler propHandler = pd.prop.getPropHandler();
            if (propHandler == null || !(propHandler instanceof StorageProp) || (object = (JSONObject)pd.getPropMetaData("database")) == null || (id = (String)object.get((Object)"player")) == null || !id.equals(player.getUniqueId().toString())) continue;
            toRemove.add(pd);
        }
        for (PropData pd : toRemove) {
            pd.remove();
        }
    }

    public static void deleteAllBaseBuildingProps() {
        ArrayList<PropData> toRemove = new ArrayList<PropData>();
        for (PropData pd : ZombiEraCore.getPropManager().propDataMap.values()) {
            PropHandler propHandler = pd.prop.getPropHandler();
            if (!(propHandler instanceof StorageProp) && !(propHandler instanceof LandClaimerProp)) continue;
            toRemove.add(pd);
        }
        for (PropData pd : toRemove) {
            pd.remove();
        }
    }

    public static List<PropDataView> loadAllProps() {
        ArrayList<PropDataView> propDataList = new ArrayList<PropDataView>();
        try {
            String query = "SELECT * FROM props";
            ResultSet resultSet = DBManager.executeQuery(query);
            while (resultSet.next()) {
                PropDataView propData = PropDataView.fromResultSet(resultSet, List.of("id", "prop", "x", "y", "z", "yaw", "pitch", "xD", "yD", "zD", "world", "metadata"));
                propDataList.add(propData);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return propDataList;
    }
}

