/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.world;

import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import zombieworldproject.zombieracore.misc.other.Vector3;

public class PopulatorData {

    public static class DelayedChunk {
        public ChunkSnapshot chunk;
        public Chunk realChunk;
        public Random random;
        public World world;

        public DelayedChunk(World world, Random random, Chunk realChunk) {
            this.realChunk = realChunk;
            this.world = world;
            this.random = random;
            this.chunk = realChunk.getChunkSnapshot();
        }
    }

    public static class TreeData {
        public TreeType typ;
        public Vector3 loc;
        public ChunkSnapshot chunk;
        public boolean applied = false;

        public TreeData(TreeType typ, Vector3 loc, ChunkSnapshot chunk) {
            this.typ = typ;
            this.loc = loc;
            this.chunk = chunk;
        }

        public void apply(World world) {
            if (!this.applied) {
                world.generateTree(new Location(world, this.loc.X + (double)(this.chunk.getX() * 16), this.loc.Y, this.loc.Z + (double)(this.chunk.getZ() * 16)), this.typ);
                this.applied = true;
            }
        }
    }

    public static class DefaultBlockData {
        public Material typ;
        public Vector3 loc;
        public ChunkSnapshot chunk = null;
        public boolean applied = false;
        public Integer chunkX = null;
        public Integer chunkZ = null;

        public DefaultBlockData(Material typ, Vector3 loc, ChunkSnapshot chunk) {
            this.typ = typ;
            this.loc = loc;
            this.chunk = chunk;
        }

        public DefaultBlockData(Material typ, Vector3 loc, int chunkX, int chunkZ) {
            this.typ = typ;
            this.loc = loc;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }

        public void apply(World world) {
            if (!this.applied) {
                if (this.chunk != null) {
                    world.setType(new Location(world, this.loc.X + (double)(this.chunk.getX() * 16), this.loc.Y, this.loc.Z + (double)(this.chunk.getZ() * 16)), this.typ);
                } else {
                    world.setType(new Location(world, this.loc.X + (double)(this.chunkX * 16), this.loc.Y, this.loc.Z + (double)(this.chunkZ * 16)), this.typ);
                }
                this.applied = true;
            }
        }
    }
}

