/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.world;

import external.FastNoiseLite;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import zombieworldproject.zombieracore.world.ZEBiomeProvider;
import zombieworldproject.zombieracore.world.worldpopulators.OneBlockPopulator;
import zombieworldproject.zombieracore.world.worldpopulators.StructurePopulator;
import zombieworldproject.zombieracore.world.worldpopulators.TreePopulator;

public class ZEChunkGenerator
extends ChunkGenerator {
    public static Material TopBlock = Material.SAND;
    public static List<BlockPopulator> Populators = Arrays.asList(new BlockPopulator[]{new StructurePopulator(), new TreePopulator(), new OneBlockPopulator()});
    private final FastNoiseLite terrainNoise = new FastNoiseLite();
    private final FastNoiseLite detailNoise = new FastNoiseLite();

    public ZEChunkGenerator() {
        this.terrainNoise.SetFrequency(0.007f);
        this.detailNoise.SetFrequency(0.09f);
        this.terrainNoise.SetFractalType(FastNoiseLite.FractalType.FBm);
        this.terrainNoise.SetFractalOctaves(5);
        this.terrainNoise.SetFractalLacunarity(5.0E-6f);
    }

    public void generateNoise(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        if (worldInfo == null) {
            ZEChunkGenerator.$$$reportNull$$$0(0);
        }
        if (random == null) {
            ZEChunkGenerator.$$$reportNull$$$0(1);
        }
        int minHeight = 60;
        chunkData.setRegion(0, 1, 0, 16, minHeight, 16, Material.SANDSTONE);
        chunkData.setRegion(0, 0, 0, 16, 1, 16, Material.BEDROCK);
        for (int y = minHeight; y < 66 && y < chunkData.getMaxHeight(); ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    float noise2 = this.terrainNoise.GetNoise(x + chunkX * 16, z + chunkZ * 16) * 2.0f + this.detailNoise.GetNoise(x + chunkX * 16, z + chunkZ * 16) / 10.0f;
                    if (62.0f + 30.0f * noise2 > (float)y) {
                        chunkData.setBlock(x, y, z, TopBlock);
                        continue;
                    }
                    if (y >= 61) continue;
                    chunkData.setBlock(x, y, z, TopBlock);
                }
            }
        }
    }

    @NotNull
    public List<BlockPopulator> getDefaultPopulators(@NotNull World world) {
        if (world == null) {
            ZEChunkGenerator.$$$reportNull$$$0(2);
        }
        List<BlockPopulator> list = Populators;
        if (list == null) {
            ZEChunkGenerator.$$$reportNull$$$0(3);
        }
        return list;
    }

    public BiomeProvider getDefaultBiomeProvider(@NotNull WorldInfo worldInfo) {
        if (worldInfo == null) {
            ZEChunkGenerator.$$$reportNull$$$0(4);
        }
        return new ZEBiomeProvider();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worldInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "random";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "world";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zombieworldproject/zombieracore/world/ZEChunkGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "zombieworldproject/zombieracore/world/ZEChunkGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPopulators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateNoise";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPopulators";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBiomeProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

