/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.world.structuremanager;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.TrapDoor;
import zombieworldproject.zombieracore.world.structuremanager.StructureBlockData;

public class StructureBlock {
    public Material type;
    public Integer x;
    public Integer y;
    public Integer z;
    public String blockFace;
    public String isDoorOpened;
    public String buttonRotation;
    public List<BlockFace> blockFaces = null;
    public StructureBlockData blockData;

    public StructureBlock(Material type, Integer x, Integer y, Integer z, String blockFace, String isTrapDoorOpen, String buttonRotation, String blockFaces) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockFace = blockFace;
        this.isDoorOpened = isTrapDoorOpen;
        this.buttonRotation = buttonRotation;
        if (!blockFaces.equals("n")) {
            String[] bF = blockFaces.split(",");
            this.blockFaces = new ArrayList<BlockFace>();
            for (String s : bF) {
                this.blockFaces.add(BlockFace.valueOf((String)s));
            }
        }
        this.blockData = this.createBlockData();
    }

    public StructureBlockData createBlockData() {
        BlockData bd = this.type.createBlockData();
        if (bd instanceof Orientable) {
            ((Orientable)bd).setAxis(Axis.valueOf((String)this.blockFace));
        } else if (bd instanceof Directional) {
            ((Directional)bd).setFacing(BlockFace.valueOf((String)this.blockFace));
            if (!this.isDoorOpened.equals("n") && bd instanceof TrapDoor) {
                ((TrapDoor)bd).setOpen(this.isDoorOpened.equals("1"));
            } else if (!this.buttonRotation.equals("n") && bd instanceof FaceAttachable) {
                ((FaceAttachable)bd).setAttachedFace(FaceAttachable.AttachedFace.valueOf((String)this.buttonRotation));
            } else if (bd instanceof Door) {
                return new StructureBlockData(bd, false, 1);
            }
        } else if (bd instanceof MultipleFacing) {
            for (BlockFace face : this.blockFaces) {
                ((MultipleFacing)bd).setFace(face, true);
            }
            return new StructureBlockData(bd, false);
        }
        return new StructureBlockData(bd, true);
    }
}

