/*
 * Decompiled with CFR 0.152.
 */
package zombieworldproject.zombieracore.world.structuremanager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.entity.Player;
import zombieworldproject.zombieracore.ZombiEraCore;
import zombieworldproject.zombieracore.world.structuremanager.Structure;
import zombieworldproject.zombieracore.world.structuremanager.StructureBlock;
import zombieworldproject.zombieracore.world.structuremanager.StructureSelection;

public final class ZEStructureManager {
    public static Map<String, Structure> fileStructures = new HashMap<String, Structure>();
    public static Map<Player, Structure> lastStructurePlayer = new HashMap<Player, Structure>();
    public static Map<Player, StructureSelection> lastSelectionPlayer = new HashMap<Player, StructureSelection>();
    public static List<Player> selectionLock = new ArrayList<Player>();

    public static void loadFileStructures() {
        fileStructures.clear();
        String directoryPath = String.valueOf(ZombiEraCore.instance.getDataFolder()) + "/structures/";
        File f = new File(directoryPath);
        if (f.exists() && f.isDirectory()) {
            File[] listOfFiles;
            ZombiEraCore.debugInfo("Structures: loading...");
            File folder = new File(directoryPath);
            for (File file : listOfFiles = folder.listFiles()) {
                if (!file.isFile()) continue;
                ArrayList<String> blocks = new ArrayList<String>();
                try {
                    File myObj = new File(directoryPath + file.getName());
                    Scanner myReader = new Scanner(myObj);
                    while (myReader.hasNextLine()) {
                        String data = myReader.nextLine();
                        if (data.length() <= 4) continue;
                        blocks.add(data);
                    }
                    myReader.close();
                }
                catch (FileNotFoundException e) {
                    ZombiEraCore.debugInfo("An error occurred.");
                    e.printStackTrace();
                }
                ZombiEraCore.debugInfo("Structure " + file.getName() + " loaded.");
                fileStructures.put(file.getName(), new Structure(blocks));
            }
        }
        ZombiEraCore.debugInfo("Structures total: " + fileStructures.size());
        ZombiEraCore.debugInfo("Structures: loading finished.");
    }

    public static Boolean saveFile(Player player, String name) {
        if (!lastStructurePlayer.containsKey(player)) {
            return false;
        }
        String directoryPath = String.valueOf(ZombiEraCore.instance.getDataFolder()) + "/structures/";
        String path = directoryPath + name + ".zws";
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            directory.mkdir();
        }
        try {
            File myObj = new File(path);
            if (myObj.createNewFile()) {
                ZombiEraCore.debugInfo("File created: " + myObj.getName());
            } else {
                ZombiEraCore.debugInfo("File already exists.");
            }
        }
        catch (IOException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
        try {
            FileWriter myWriter = new FileWriter(path);
            StringBuilder content = new StringBuilder();
            List<String> blocks = ZEStructureManager.lastStructurePlayer.get((Object)player).blocks;
            for (String block : blocks) {
                content.append(String.format("%s\n", block));
            }
            myWriter.write(content.toString());
            myWriter.close();
            ZombiEraCore.debugInfo("Successfully wrote to the file.");
        }
        catch (IOException e) {
            ZombiEraCore.debugInfo("An error occurred while writing a file.");
            e.printStackTrace();
        }
        return true;
    }

    public static void setRegionAir(Location location, Structure structure) {
        World world = location.getWorld();
        int realY = location.getBlockY();
        int realX = location.getBlockX();
        int realZ = location.getBlockZ();
        int xSize = structure.maxX - structure.minX;
        int ySize = structure.maxY - structure.minY;
        int zSize = structure.maxZ - structure.minZ;
        int xStart = structure.minX + realX;
        int yStart = structure.minY + realY;
        int zStart = structure.minZ + realZ;
        int blockCount = xSize * ySize * zSize;
        for (int i = 0; i < blockCount; ++i) {
            int x = xStart + i % xSize;
            int y = yStart + i / xSize % ySize;
            int z = zStart + i / (xSize * ySize);
            world.getBlockAt(x, y, z).setType(Material.AIR);
        }
    }

    public static Integer checkGroundAirCount(Location location, Structure structure) {
        World world = location.getWorld();
        int realX = location.getBlockX();
        int realZ = location.getBlockZ();
        int realY = structure.minY + location.getBlockY();
        int airCount = 0;
        int maxAirCount = (structure.maxX - structure.minX) * (structure.maxZ - structure.minZ);
        for (int x = structure.minX + realX; x < structure.maxX + realX; ++x) {
            for (int z = structure.minZ + realZ; z < structure.maxZ + realZ; ++z) {
                if (world.getBlockAt(x, realY, z).getType() != Material.AIR || ++airCount < maxAirCount) continue;
                return airCount;
            }
        }
        return airCount;
    }

    public static void selectPlayer(Player player, Integer x, Integer y, Integer z, Integer posNumber) {
        if (!selectionLock.contains(player)) {
            ChatColor color = posNumber == 1 ? ChatColor.GREEN : ChatColor.AQUA;
            if (!lastSelectionPlayer.containsKey(player)) {
                lastSelectionPlayer.put(player, new StructureSelection(player));
            }
            StructureSelection sel = lastSelectionPlayer.get(player);
            if (posNumber == 1) {
                sel.x1 = x;
                sel.y1 = y;
                sel.z1 = z;
                lastSelectionPlayer.put(player, sel);
                ZombiEraCore.playerInfo(player, String.format(String.valueOf(color) + "POS 1 Selected! x: %s, y: %s, z: %s", x, y, z));
            } else if (posNumber == 2) {
                sel.x2 = x;
                sel.y2 = y;
                sel.z2 = z;
                lastSelectionPlayer.put(player, sel);
                ZombiEraCore.playerInfo(player, String.format(String.valueOf(color) + "POS 2 Selected! x: %s, y: %s, z: %s", x, y, z));
            }
            if (sel.isReady().booleanValue()) {
                ZombiEraCore.playerInfo(player, String.format(String.valueOf(color) + "Selection ready to copy!", new Object[0]));
                ZombiEraCore.playerInfo(player, String.format(String.valueOf(color) + "POS 1 -> x: %s, y: %s, z: %s", sel.x1, sel.y1, sel.z1));
                ZombiEraCore.playerInfo(player, String.format(String.valueOf(color) + "POS 2 -> x: %s, y: %s, z: %s", sel.x2, sel.y2, sel.z2));
            }
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 0.5f);
        }
    }

    public static void CopySelection(Player player) {
        if (!selectionLock.contains(player)) {
            StructureSelection sel = lastSelectionPlayer.get(player);
            if (sel != null && sel.isReady().booleanValue()) {
                ZombiEraCore.playerInfo(player, "Copying structure...");
                List<String> newBlocks = ZEStructureManager.copyStructure(player.getWorld(), sel.x1, sel.y1, sel.z1, sel.x2, sel.y2, sel.z2);
                Structure structure = new Structure(newBlocks);
                lastStructurePlayer.put(player, structure);
                ZombiEraCore.playerInfo(player, "Structure copied! Type '/zwstructure save <name>' to save it as a file and '/zwstructure load <name>' to load it.");
                ZombiEraCore.playerInfo(player, String.format("Copied %s blocks!", newBlocks.size()));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 2.0f);
            } else {
                ZombiEraCore.playerInfo(player, "Nothing to copy! Select pos 1 & pos 2 first!");
            }
        }
    }

    public static boolean copyToPlayer(Player player, String structureName) {
        if (fileStructures.containsKey(structureName)) {
            lastStructurePlayer.put(player, fileStructures.get(structureName));
            return true;
        }
        return false;
    }

    public static List<String> copyStructure(World world, Integer x1, Integer y1, Integer z1, Integer x2, Integer y2, Integer z2) {
        ArrayList<String> newBlocks = new ArrayList<String>();
        int xMax = Math.max(x1, x2) + 1;
        int yMax = Math.max(y1, y2) + 1;
        int zMax = Math.max(z1, z2) + 1;
        int xMin = Math.min(x1, x2);
        int yMin = Math.min(y1, y2);
        int zMin = Math.min(z1, z2);
        for (int y = yMin; y < yMax; ++y) {
            for (int x = xMin; x < xMax; ++x) {
                for (int z = zMin; z < zMax; ++z) {
                    Block block = world.getBlockAt(x, y, z);
                    String type = String.valueOf(block.getType());
                    BlockData bd = block.getBlockData();
                    String blockFace = "n";
                    String isDoorOpened = "n";
                    String buttonAttached = "n";
                    StringBuilder multipleFaces = new StringBuilder("n");
                    if (bd instanceof Orientable) {
                        Orientable obd = (Orientable)bd;
                        blockFace = obd.getAxis().name();
                    } else if (bd instanceof Directional) {
                        Directional dbd = (Directional)bd;
                        blockFace = dbd.getFacing().toString();
                        if (bd instanceof TrapDoor) {
                            boolean isOpen = ((TrapDoor)bd).isOpen();
                            isDoorOpened = isOpen ? "1" : "0";
                        } else if (bd instanceof Door) {
                            if (block.getRelative(BlockFace.DOWN).getBlockData() instanceof Door) continue;
                            boolean isOpen = ((Door)bd).isOpen();
                            isDoorOpened = isOpen ? "1" : "0";
                        } else if (bd instanceof FaceAttachable) {
                            buttonAttached = ((FaceAttachable)bd).getAttachedFace().toString();
                        }
                    } else if (bd instanceof MultipleFacing) {
                        MultipleFacing mbd = (MultipleFacing)bd;
                        Set faces = mbd.getFaces();
                        if (faces.size() > 0) {
                            multipleFaces = new StringBuilder();
                        }
                        for (BlockFace f : faces) {
                            multipleFaces.append(f.toString());
                            multipleFaces.append(",");
                        }
                        if (multipleFaces.length() >= 2) {
                            multipleFaces = new StringBuilder(multipleFaces.substring(0, multipleFaces.length() - 1));
                        }
                    }
                    if (type == "AIR") continue;
                    newBlocks.add(String.format("%s;%s;%s;%s;%s;%s;%s;%s", type, x - xMin, y - yMin, z - zMin, blockFace, isDoorOpened, buttonAttached, multipleFaces));
                }
            }
        }
        return newBlocks;
    }

    public static void structurePaste(Player player) {
        Structure structure = lastStructurePlayer.get(player);
        World world = player.getWorld();
        Location playerLoc = player.getLocation().add(1.0, 0.0, 1.0);
        if (structure != null) {
            ZombiEraCore.playerInfo(player, "Pasting blocks...");
            List<StructureBlock> blocks = structure.realBlocks;
            for (StructureBlock b : blocks) {
                Block block = world.getBlockAt(b.x + playerLoc.getBlockX(), b.y + playerLoc.getBlockY(), b.z + playerLoc.getBlockZ());
                b.blockData.setBlockData(block);
            }
            ZombiEraCore.playerInfo(player, String.format("Set %s blocks.", blocks.size()));
        } else {
            ZombiEraCore.playerInfo(player, "Nothing to paste!");
        }
    }

    public static boolean structurePaste(World world, Structure structure, Integer realX, Integer realY, Integer realZ) {
        if (structure != null) {
            List<StructureBlock> blocks = structure.realBlocks;
            for (StructureBlock b : blocks) {
                Block block = world.getBlockAt(b.x + realX, b.y + realY, b.z + realZ);
                b.blockData.setBlockData(block);
            }
            return true;
        }
        return false;
    }
}

