/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.net.bytebuddy.description.modifier.Visibility;
import com.comphenix.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import com.comphenix.net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import com.comphenix.net.bytebuddy.implementation.FieldAccessor;
import com.comphenix.net.bytebuddy.implementation.InvocationHandlerAdapter;
import com.comphenix.net.bytebuddy.implementation.MethodCall;
import com.comphenix.net.bytebuddy.implementation.MethodDelegation;
import com.comphenix.net.bytebuddy.implementation.bind.annotation.AllArguments;
import com.comphenix.net.bytebuddy.implementation.bind.annotation.FieldValue;
import com.comphenix.net.bytebuddy.implementation.bind.annotation.Origin;
import com.comphenix.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import com.comphenix.net.bytebuddy.matcher.ElementMatcher;
import com.comphenix.net.bytebuddy.matcher.ElementMatchers;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.BanEntry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.profile.PlayerProfile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SerializedOfflinePlayer
implements OfflinePlayer,
Serializable {
    private static final long serialVersionUID = -2728976288470282810L;
    private transient Location bedSpawnLocation;
    private String name;
    private UUID uuid;
    private long firstPlayed;
    private long lastPlayed;
    private boolean operator;
    private boolean banned;
    private boolean playedBefore;
    private boolean online;
    private boolean whitelisted;
    private long lastLogin;
    private long lastSeen;
    private static final Constructor<?> proxyPlayerConstructor = SerializedOfflinePlayer.setupProxyPlayerConstructor();

    public SerializedOfflinePlayer() {
    }

    public SerializedOfflinePlayer(OfflinePlayer offline) {
        this.name = offline.getName();
        this.uuid = offline.getUniqueId();
        this.firstPlayed = offline.getFirstPlayed();
        this.lastPlayed = offline.getLastPlayed();
        this.operator = offline.isOp();
        this.banned = offline.isBanned();
        this.playedBefore = offline.hasPlayedBefore();
        this.online = offline.isOnline();
        this.whitelisted = offline.isWhitelisted();
        if (Util.isUsingFolia()) {
            // empty if block
        }
    }

    public boolean isOp() {
        return this.operator;
    }

    public void setOp(boolean operator) {
        this.operator = operator;
    }

    public Map<String, Object> serialize() {
        throw new UnsupportedOperationException();
    }

    public Location getBedSpawnLocation() {
        return this.bedSpawnLocation;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void incrementStatistic(Statistic statistic) throws IllegalArgumentException {
    }

    public void decrementStatistic(Statistic statistic) throws IllegalArgumentException {
    }

    public void incrementStatistic(Statistic statistic, int i) throws IllegalArgumentException {
    }

    public void decrementStatistic(Statistic statistic, int i) throws IllegalArgumentException {
    }

    public void setStatistic(Statistic statistic, int i) throws IllegalArgumentException {
    }

    public int getStatistic(Statistic statistic) throws IllegalArgumentException {
        return 0;
    }

    public void incrementStatistic(Statistic statistic, Material material) throws IllegalArgumentException {
    }

    public void decrementStatistic(Statistic statistic, Material material) throws IllegalArgumentException {
    }

    public int getStatistic(Statistic statistic, Material material) throws IllegalArgumentException {
        return 0;
    }

    public void incrementStatistic(Statistic statistic, Material material, int i) throws IllegalArgumentException {
    }

    public void decrementStatistic(Statistic statistic, Material material, int i) throws IllegalArgumentException {
    }

    public void setStatistic(Statistic statistic, Material material, int i) throws IllegalArgumentException {
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) throws IllegalArgumentException {
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) throws IllegalArgumentException {
    }

    public int getStatistic(Statistic statistic, EntityType entityType) throws IllegalArgumentException {
        return 0;
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int i) throws IllegalArgumentException {
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int i) {
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int i) {
    }

    public Location getLastDeathLocation() {
        return null;
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    @NotNull
    public PlayerProfile getPlayerProfile() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasPlayedBefore() {
        return this.playedBefore;
    }

    public boolean isBanned() {
        return this.banned;
    }

    @Nullable
    public BanEntry<PlayerProfile> ban(@Nullable String s, @Nullable Date date, @Nullable String s1) {
        this.setBanned(true);
        return null;
    }

    @Nullable
    public BanEntry<PlayerProfile> ban(@Nullable String s, @Nullable Instant instant, @Nullable String s1) {
        this.setBanned(true);
        return null;
    }

    @Nullable
    public BanEntry<PlayerProfile> ban(@Nullable String s, @Nullable Duration duration, @Nullable String s1) {
        this.setBanned(true);
        return null;
    }

    public void setBanned(boolean banned) {
        this.banned = banned;
    }

    public boolean isOnline() {
        return this.online;
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public void setWhitelisted(boolean whitelisted) {
        this.whitelisted = whitelisted;
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeUTF(this.bedSpawnLocation.getWorld().getName());
        output.writeDouble(this.bedSpawnLocation.getX());
        output.writeDouble(this.bedSpawnLocation.getY());
        output.writeDouble(this.bedSpawnLocation.getZ());
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        this.bedSpawnLocation = new Location(this.getWorld(input.readUTF()), input.readDouble(), input.readDouble(), input.readDouble());
    }

    private World getWorld(String name) {
        try {
            return Bukkit.getServer().getWorld(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Player getPlayer() {
        try {
            return Bukkit.getServer().getPlayerExact(this.name);
        }
        catch (Exception e) {
            return this.getProxyPlayer();
        }
    }

    public Player getProxyPlayer() {
        try {
            return (Player)proxyPlayerConstructor.newInstance(this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access reflection.", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate object.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error in invocation.", e);
        }
    }

    private static Constructor<? extends Player> setupProxyPlayerConstructor() {
        Method[] offlinePlayerMethods = OfflinePlayer.class.getMethods();
        String[] methodNames = new String[offlinePlayerMethods.length];
        for (int idx = 0; idx < offlinePlayerMethods.length; ++idx) {
            methodNames[idx] = offlinePlayerMethods[idx].getName();
        }
        final ConcurrentHashMap accessorCache = new ConcurrentHashMap();
        ElementMatcher.Junction forwardedMethods = ElementMatchers.namedOneOf(methodNames);
        try {
            MethodDelegation forwarding = MethodDelegation.withDefaultConfiguration().to(new Object(){

                @RuntimeType
                public Object intercept(@Origin Method calledMethod, @AllArguments Object[] args, @FieldValue(value="offlinePlayer") OfflinePlayer proxy) {
                    MethodAccessor accessor = accessorCache.computeIfAbsent(calledMethod, method -> {
                        if (OfflinePlayer.class.isAssignableFrom(method.getDeclaringClass())) {
                            return Accessors.getMethodAccessor(OfflinePlayer.class, method.getName(), method.getParameterTypes());
                        }
                        return Accessors.getMethodAccessor(method);
                    });
                    return accessor.invoke(proxy, args);
                }
            });
            InvocationHandlerAdapter throwException = InvocationHandlerAdapter.of((obj, method, args) -> {
                throw new UnsupportedOperationException("The method " + method.getName() + " is not supported for offline players.");
            });
            return ByteBuddyFactory.getInstance().createSubclass(PlayerUnion.class, ConstructorStrategy.Default.NO_CONSTRUCTORS).name(SerializedOfflinePlayer.class.getPackage().getName() + ".PlayerInvocationHandler").defineField("offlinePlayer", (Type)((Object)OfflinePlayer.class), Visibility.PRIVATE).defineConstructor(Visibility.PUBLIC).withParameters(new Type[]{OfflinePlayer.class}).intercept(MethodCall.invoke(Object.class.getDeclaredConstructor(new Class[0])).andThen(FieldAccessor.ofField("offlinePlayer").setsArgumentAt(0))).method(forwardedMethods).intercept(forwarding).method(ElementMatchers.not(forwardedMethods)).intercept(throwException).make().load(ByteBuddyFactory.getInstance().getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(OfflinePlayer.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find Player constructor!", e);
        }
    }

    private static interface PlayerUnion
    extends OfflinePlayer,
    Player {
    }
}

