/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect;

import com.comphenix.protocol.reflect.MethodInfo;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class FuzzyReflection {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private final Class<?> source;
    private final boolean forceAccess;

    public FuzzyReflection(Class<?> source, boolean forceAccess) {
        this.source = source;
        this.forceAccess = forceAccess;
    }

    public static FuzzyReflection fromClass(Class<?> source) {
        return FuzzyReflection.fromClass(source, false);
    }

    public static FuzzyReflection fromClass(Class<?> source, boolean forceAccess) {
        return new FuzzyReflection(source, forceAccess);
    }

    public static FuzzyReflection fromObject(Object reference) {
        return new FuzzyReflection(reference.getClass(), false);
    }

    public static FuzzyReflection fromObject(Object reference, boolean forceAccess) {
        return new FuzzyReflection(reference.getClass(), forceAccess);
    }

    public static <T> T getFieldValue(Object instance, Class<T> fieldClass, boolean forceAccess) {
        return (T)Accessors.getFieldAccessor(instance.getClass(), fieldClass, forceAccess).get(instance);
    }

    @SafeVarargs
    public static <T> Set<T> combineArrays(T[] ... arrays) {
        LinkedHashSet result = new LinkedHashSet();
        for (T[] elements : arrays) {
            if (elements == null) continue;
            Collections.addAll(result, elements);
        }
        return result;
    }

    public Class<?> getSource() {
        return this.source;
    }

    public boolean isForceAccess() {
        return this.forceAccess;
    }

    public Object getSingleton() {
        try {
            Method method = this.getMethod(FuzzyMethodContract.newBuilder().parameterCount(0).returnDerivedOf(this.source).requireModifier(8).build());
            return Accessors.getMethodAccessor(method).invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException method) {
            try {
                Field field = this.getField(FuzzyFieldContract.newBuilder().typeDerivedOf(this.source).requireModifier(8).build());
                return Accessors.getFieldAccessor(field).get(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException("Unable to retrieve singleton instance of " + this.source);
            }
        }
    }

    public Method getMethod(AbstractFuzzyMatcher<MethodInfo> matcher) {
        List<Method> result = this.getMethodList(matcher);
        if (result.size() > 0) {
            return result.get(0);
        }
        throw new IllegalArgumentException("Unable to find a method that matches " + matcher);
    }

    public Method getMethod(AbstractFuzzyMatcher<MethodInfo> matcher, String preferred) {
        List<Method> result = this.getMethodList(matcher);
        if (result.size() > 1 && preferred != null) {
            for (Method method : result) {
                if (!method.getName().equals(preferred)) continue;
                return method;
            }
        }
        if (result.size() > 0) {
            return result.get(0);
        }
        throw new IllegalArgumentException("Unable to find a method that matches " + matcher);
    }

    public Method getMethodByName(String nameRegex) {
        Pattern match = Pattern.compile(nameRegex);
        for (Method method : this.getMethods()) {
            if (!match.matcher(method.getName()).matches()) continue;
            return method;
        }
        throw new IllegalArgumentException(String.format("Unable to find a method in %s that matches \"%s\"", this.source, nameRegex));
    }

    public Method getMethodByParameters(String name, Class<?> ... args) {
        for (Method method : this.getMethods()) {
            if (!Arrays.equals(method.getParameterTypes(), args)) continue;
            return method;
        }
        throw new IllegalArgumentException(String.format("Unable to find %s(%s) in %s", name, COMMA_JOINER.join((Object[])args), this.source));
    }

    public Method getMethodByReturnTypeAndParameters(String name, Class<?> returnType, Class<?> ... args) {
        List<Method> methods = this.getMethodListByParameters(returnType, args);
        if (methods.size() > 0) {
            return methods.get(0);
        }
        throw new IllegalArgumentException(String.format("Unable to find %s(%s): %s in %s", name, COMMA_JOINER.join((Object[])args), returnType, this.source));
    }

    public List<Method> getMethodList(AbstractFuzzyMatcher<MethodInfo> matcher) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : this.getMethods()) {
            if (!matcher.isMatch(MethodInfo.fromMethod(method), this.source)) continue;
            methods.add(method);
        }
        return methods;
    }

    public List<Method> getMethodListByParameters(Class<?> returnType, Class<?> ... args) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : this.getMethods()) {
            if (!method.getReturnType().equals(returnType) || !Arrays.equals(method.getParameterTypes(), args)) continue;
            methods.add(method);
        }
        return methods;
    }

    public Field getField(AbstractFuzzyMatcher<Field> matcher) {
        List<Field> result = this.getFieldList(matcher);
        if (result.size() > 0) {
            return result.get(0);
        }
        throw new IllegalArgumentException("Unable to find a field that matches " + matcher);
    }

    public Field getFieldByName(String nameRegex) {
        Pattern match = Pattern.compile(nameRegex);
        for (Field field : this.getFields()) {
            if (!match.matcher(field.getName()).matches()) continue;
            return field;
        }
        throw new IllegalArgumentException(String.format("Unable to find a field with a name matching \"%s\" in %s", nameRegex, this.source));
    }

    public Field getFieldByType(String name, Class<?> type) {
        List<Field> fields = this.getFieldListByType(type);
        if (fields.size() > 0) {
            return fields.get(0);
        }
        throw new IllegalArgumentException(String.format("Unable to find a field \"%s\" with the type %s in %s", name, type, this.source));
    }

    public List<Field> getFieldListByType(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.getFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            fields.add(field);
        }
        return fields;
    }

    public Field getParameterizedField(Class<?> fieldType, Class<?> ... params) {
        for (Field field : this.getFields()) {
            Type type;
            if (!field.getType().equals(fieldType) || !((type = field.getGenericType()) instanceof ParameterizedType) || !Arrays.equals(((ParameterizedType)type).getActualTypeArguments(), params)) continue;
            return field;
        }
        throw new IllegalArgumentException(String.format("Unable to find a field of type %s<%s> in %s", fieldType, COMMA_JOINER.join((Object[])params), this.source));
    }

    public List<Field> getFieldList(AbstractFuzzyMatcher<Field> matcher) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.getFields()) {
            if (!matcher.isMatch(field, this.source)) continue;
            fields.add(field);
        }
        return fields;
    }

    public Field getFieldByType(String typeRegex) {
        Pattern match = Pattern.compile(typeRegex);
        for (Field field : this.getFields()) {
            String name = field.getType().getName();
            if (!match.matcher(name).matches()) continue;
            return field;
        }
        throw new IllegalArgumentException(String.format("Unable to find a field with a type that matches \"%s\" in %s", typeRegex, this.source));
    }

    public Constructor<?> getConstructor(AbstractFuzzyMatcher<MethodInfo> matcher) {
        List<Constructor<?>> result = this.getConstructorList(matcher);
        if (result.size() > 0) {
            return result.get(0);
        }
        throw new IllegalArgumentException("Unable to find a method that matches " + matcher);
    }

    public List<Constructor<?>> getConstructorList(AbstractFuzzyMatcher<MethodInfo> matcher) {
        ArrayList constructors = new ArrayList();
        for (Constructor<?> constructor : this.getConstructors()) {
            if (!matcher.isMatch(MethodInfo.fromConstructor(constructor), this.source)) continue;
            constructors.add(constructor);
        }
        return constructors;
    }

    public Set<Field> getFields() {
        if (this.forceAccess) {
            return FuzzyReflection.combineArrays(this.source.getDeclaredFields(), this.source.getFields());
        }
        return FuzzyReflection.combineArrays(new Field[][]{this.source.getFields()});
    }

    public Set<Field> getDeclaredFields(Class<?> excludeClass) {
        if (this.forceAccess) {
            LinkedHashSet fields = Sets.newLinkedHashSet();
            for (Class<?> current = this.source; current != null && current != excludeClass; current = current.getSuperclass()) {
                fields.addAll(Arrays.asList(current.getDeclaredFields()));
            }
            return fields;
        }
        return this.getFields();
    }

    public Set<Method> getMethods() {
        if (this.forceAccess) {
            return FuzzyReflection.combineArrays(this.source.getDeclaredMethods(), this.source.getMethods());
        }
        return FuzzyReflection.combineArrays(new Method[][]{this.source.getMethods()});
    }

    public Set<Constructor<?>> getConstructors() {
        return FuzzyReflection.combineArrays(new Constructor[][]{this.forceAccess ? this.source.getDeclaredConstructors() : this.source.getConstructors()});
    }
}

